import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import {
    UUID,
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    handleUpload
} from '../../utils';


@Form.create()
export default class BaseInfoForm extends Component {

    static propsType = {
        cates: PropTypes.array,
        product: PropTypes.object,
        user: PropTypes.object,
        dispatch: PropTypes.func
    };

    constructor(props, context) {
        super(props, context);

        this.state = {
            priviewVisible: false,
            priviewImage: '',
            fileList: []
        };
    }

    componentWillMount(){
        const {itemPic} = this.props.product;

        if (itemPic) {
            this.setState({
                fileList:[{
                    uid: UUID(),
                    status: 'done',
                    url: itemPic,
                    thumbUrl: itemPic + '!t'
                }]
            });
        } else {
            console.log('没有找到商品主图', this.props.product);
        }
    }

    handleSubmit(e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();

        if (Array.isArray(data.categoryId) && data.categoryId.length === 2) {
            data.categoryId = data.categoryId[1];
        } else {
            delete data.categoryId;
        }

        if (this.state.fileList && this.state.fileList[0] && this.state.fileList[0].url) {
            data['itemPic'] = this.state.fileList[0].url;
        }

        data.id = this.props.product.id;

        console.log('收到表单值：', data);

        this.props.dispatch({
            type: 'UPDATE_PRODUCT_ITEM',
            item: data
        });

    };

    render() {
        const {user, cates, product, loading, form:{getFieldProps}} = this.props;

        let productCate = [];

        if (product && product.categoryId && product.categoryParentId) {
            productCate = [product.categoryParentId, product.categoryId];
        }

        return (
            <Spin spinning={loading}>
                <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                    <Form.Item label="产品类目" {...smallFormItemLayout}>
                        <Cascader options={cates} placeholder="请选产品类目"
                            {...getFieldProps('categoryId', {
                                initialValue: productCate
                            })}
                        />
                    </Form.Item>
                    <Form.Item label="产品短标题" {...smallFormItemLayout}>
                        <Input placeholder="产品短标题"
                            {...getFieldProps('itemShortTitle', {
                                initialValue: product.itemShortTitle,
                            })}
                        />
                    </Form.Item>
                    <Form.Item label="产品标题" {...formItemLayout}>
                        <Input placeholder="产品标题"
                            {...getFieldProps('itemTitle', {
                                initialValue: product.itemTitle
                            })}
                        />
                    </Form.Item>
                    <Form.Item label="产品简介" {...formItemLayout}>
                        <Input type="textarea" rows={5} placeholder="产品简介"
                            {...getFieldProps('summary', {
                                initialValue: product.summary
                            })}
                        />
                    </Form.Item>

                    <Form.Item label="产品主图" {...formItemLayout}>
                        <Upload action="/api/fileUpload/upload" listType="picture-card"
                                multiple={true}
                                headers={{
                                    authorization: user && user.token,
                                }}
                                onChange={info=>this.setState({fileList: handleUpload(info, 1)})}
                                onPreview={file => {
                                    this.setState({
                                        priviewImage: file.url,
                                        priviewVisible: true
                                    });
                                }}
                                fileList={this.state.fileList}>
                            <Icon type="upload"/>
                            <div className="ant-upload-text">上传照片</div>
                        </Upload>
                        <Modal footer={null}
                               width="100vw"
                               visible={this.state.priviewVisible}
                               className="img-priview-dialog"
                               style={{height:'100vh', background:'transparent'}}
                               onCancel={()=>this.setState({ priviewVisible: false })}>
                            <img src={this.state.priviewImage} style={{maxWidth:'100%'}}/>
                        </Modal>
                    </Form.Item>
                    <Form.Item label="募集目标" help="本期额度, 可以输入100万, 2亿等" {...smallFormItemLayout}>
                        <Input placeholder="募集目标"
                            {...getFieldProps('fundRaisedTarget', {
                                initialValue: product.fundRaisedTarget
                            })}
                        />
                    </Form.Item>
                    <Form.Item label="产品期限" help="例如:半年期" {...smallFormItemLayout}>
                        <Input placeholder="" {...getFieldProps('duration', {
                            initialValue: product.duration
                        })} />
                    </Form.Item>
                    <Form.Item label="起投金额" help="最小购买份额"  {...smallFormItemLayout}>
                        <Input placeholder=""
                            {...getFieldProps('minimumAmount', {
                                initialValue: product.minimumAmount
                            })}
                        />
                    </Form.Item>
                    <Form.Item label="已预约" help="此处的已预约只用于显示" {...smallFormItemLayout} >
                        {
                            ((typeof product.fundReservationOver !== 'undefined') && ( product.fundReservationOver !== '')) ?
                                <div style={{maxWidth:500}}>
                                    <Input addonAfter={"实际:"+ product.fundReservationOver}
                                        {...getFieldProps('fundReservationOverFake', {
                                            initialValue: product.fundReservationOverFake
                                        })}
                                    />
                                </div>
                                :
                                <Input
                                    {...getFieldProps('fundReservationOverFake', {
                                        initialValue: product.fundReservationOverFake
                                    })}
                                />
                        }

                    </Form.Item>
                    <Form.Item label="已募集" help="此处的已募集只用于显示" {...smallFormItemLayout}>
                        {
                            ((typeof product.fundRaisedOver !== 'undefined') && (product.fundRaisedOver !== '')) ?
                                <div style={{maxWidth:500}}>
                                    <Input addonAfter={"实际:"+ product.fundRaisedOver}
                                        {...getFieldProps('fundRaisedOverFake', {
                                            initialValue: product.fundRaisedOverFake
                                        })}
                                    />
                                </div>
                                :
                                <Input
                                    {...getFieldProps('fundRaisedOverFake', {
                                        initialValue: product.fundRaisedOverFake
                                    })}
                                />
                        }
                    </Form.Item>
                    <Form.Item label="产品所属公司" {...smallFormItemLayout} >
                        <Input placeholder="产品所属公司"
                            {...getFieldProps('company', {
                                initialValue: product.company
                            })}
                        />
                    </Form.Item>
                    <Form.Item label="所属公司网址" {...smallFormItemLayout}>
                        <Input placeholder="所属公司网址"
                            {...getFieldProps('website', {
                                initialValue: product.website
                            })}
                        />
                    </Form.Item>
                    <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                        <Button type="primary" htmlType="submit" loading={loading}><Icon type="save"/>保存</Button>
                        {
                            !this.props.isCreate &&
                            <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                    style={{marginLeft:'1em'}}>
                                <Icon type="rollback" />返回
                            </Button>
                        }
                    </Form.Item>
                </Form>
            </Spin>
        );
    }
}




