import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Table, Icon, Row, Col, Button, Form, Input, Cascader, Select} from 'antd';
import {Link} from 'react-router';
import {serialize, formatDateTime, userStatusToString, filterFormItemStyle} from '../../utils';
import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';
import HeaderOperation from '../../components/HeaderOperation/HeaderOperation';

const columns = [
    {
        title: 'ID',
        dataIndex: 'id',
        key: 'id',
        width: 70,
        // fixed:'left'
    }, {
        title: '用户名',
        dataIndex: 'username',
        key: 'username',
        width:100,
    }, {
        title: '注册时间',
        dataIndex: 'dateCreated',
        key: 'dateCreated',
        width: 150,
        className: 'tac',
        render: (dateCreated, record)=>(
            <span>
                {dateCreated && formatDateTime(dateCreated)}
            </span>
        )
    }, {
        title: '角色',
        dataIndex: 'authorities',
        key: 'authorities',
        width: 200,
        className: 'tac',
        render:(authorities)=>(
            <span>{authorities}</span>
        )
    }, {
        title: 'E-mail',
        dataIndex: 'email',
        key: 'email',
        width: 200,
    }, {
        title: '手机号',
        dataIndex: 'mobile',
        key: 'mobile',
        width: 80,
        className: 'tac',
    }, {
        title: '状态',
        dataIndex: 'status',
        key: 'status',
        width: 60,
        className: 'tac',
        render: (status, record)=>(<span data-status={status}>{userStatusToString(status)}</span>)
    }
];

@connect(state=>({
    items: state.user.items,
    loading: state.user.loading,
    total: state.user.total,
}))
@Form.create()
export default class List extends Component {

    constructor(props, context) {
        super(props, context);
        this.state = {
            filterVisible: false,
        }
    }

    componentWillMount() {
        this.fetchList(this.props.location.query);
    };

    fetchList(query) {
        this.props.dispatch({
            type: 'FETCH_USER_LIST',
            query
        });
    }

    handleRowClick({id}) {
        this.props.history.push('/admin/users/' + id);
    }

    handleFilterVisible() {
        this.setState({
            filterVisible: !this.state.filterVisible
        });

    }

    handleFilterSubmit(e) {
        e.preventDefault();
        // const formData = this.props.form.getFieldsValue();
        // if (formData.categoryId && formData.categoryId[1]) {
        //     formData.categoryId = formData.categoryId[1];
        // }
        // const searchQuery = {...this.props.location.query, ...formData};
        // console.log(searchQuery);
        // this.props.history.replace(this.props.location.pathname + '?' + serialize(searchQuery));
        // this.fetchList(searchQuery);
    }

    handleResetFilterForm(e) {
        e.preventDefault();
        // this.props.form.setFieldsValue({
        //     id: undefined,
        //     status: undefined,
        //     categoryId: undefined,
        //     title: undefined
        // });
    }

    render() {

        const {
            total,
            items,
            loading,
            history:{replace},
            form:{getFieldProps},
            location:{pathname, query}
        } = this.props;

        const pagination = {
            total: total,
            pageSize: parseInt(query.s, 10) || 30,
            current: parseInt(query.p, 10) || 1,
            showSizeChanger: true,
            showTotal: total => `共 ${total} 条`,
            pageSizeOptions:['10', '30', '50', '100'],
            onShowSizeChange: (current, pageSize)=> {
                console.log('Current: ', current, '; PageSize: ', pageSize);
                query.p = current;
                query.s = pageSize;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            },
            onChange: (current) => {
                console.log('Current: ', current);
                query.p = current;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            }
        };



        const operation = (
            <HeaderOperation history={this.props.history} buttons={[{key:'filter'}]}/>
        );

        const header = (
            <MainHeader breadcrumb={['用户管理', '用户列表']}
                        title="用户列表"
                        operation={operation}>
                {
                    this.state.filterVisible &&
                    <Form className="filterForm" inline onSubmit={this.handleFilterSubmit.bind(this)}>
                        <Form.Item label="ID">
                            <Input placeholder="请输入搜索ID" {...filterFormItemStyle} {...getFieldProps('id')}/>
                        </Form.Item>
                        <Form.Item label="用户名">
                            <Input placeholder="请输入搜索用户名" {...filterFormItemStyle} {...getFieldProps('title')}/>
                        </Form.Item>
                        <Form.Item label="状态">
                            <Select placeholder="请选择状态"  {...filterFormItemStyle} {...getFieldProps('status')}>
                                <Select.Option key="status-option-default"
                                               value={null}>请选择</Select.Option>

                            </Select>
                        </Form.Item>
                        <Form.Item>
                            <Button.Group size="default">
                                <Button type="primary" size="default" htmlType="submit" loading={loading}><Icon
                                    type="search"/>筛选</Button>
                                <Button type="ghost" size="default" htmlType="reset"
                                        onClick={this.handleResetFilterForm.bind(this)}><Icon
                                    type="cross-circle-o"/>清空</Button>
                            </Button.Group>
                        </Form.Item>
                    </Form>
                }
            </MainHeader>
        );



        return (
            <Layout header={header}>
                <Table className="list-table" columns={columns}
                       dataSource={Array.isArray(items)?items:[]}
                       loading={loading}
                       pagination={pagination}
                       scroll={{ y: window.innerHeight-(this.state.filterVisible? 203 :150) }}
                       onRowClick={this.handleRowClick.bind(this)}
                />
            </Layout>
        );
    }
}



