import xFetch from './xFetch';
import {serialize} from '../utils';

export async function fetchList(query) {
    return xFetch('/api/trades' + '?' + serialize({s:30, ...query}));
}
export async function fetchItem(id) {
    return xFetch('/api/trades/' + id);
}

export async function createItem(data) {
    return xFetch('/api/trades', {
        method: 'POST',
        body: serialize(data)
    });
}

export async function settlementItem(id) {
    return xFetch('/api/trade/commission/' + id, {
        method: 'PATCH'
    });
}

export async function establish(id) {
    return xFetch('/api/trade/' + id, {
        method: 'PATCH'
    });
}
