import xFetch from '../xFetch';
import {serialize} from '../../utils';

export async function fetchList(query) {
    return xFetch('/api/admin/resources' + '?' + serialize({s:30, ...query}));
}

export async function fetchItem(id) {
    return xFetch('/api/admin/resources/' + id);
}

export async function updateItem(item) {
    return xFetch('/api/admin/resources/'+item.id, {
        method: 'PUT',
        body: serialize(item)
    });
}
