import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';

import {formItemLayout, footerFormSubmitLayout, innerHTML} from '../../utils';

@connect(state=>({
    loading: state.announcement.loading,
    item: state.announcement.item,
    isEdit: state.announcement.isEdit
}))
@Form.create()
export default class EditItem extends Component {
    constructor() {
        super(...arguments);
        this.state = {
            isEdit: false
        }
    }


    componentDidMount() {
        this.fetchItem(this.props.params.id);
    };

    componentWillReceiveProps(nextProps) {
        this.setState({isEdit: nextProps.isEdit});
    }

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_ANNOUNCEMENT_ITEM',
            id
        });
    };

    handleSubmit(e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        data.id = this.props.item.id;
        console.log(data);
        this.props.dispatch({
            type: 'UPDATE_ANNOUNCEMENT_ITEM',
            item: data
        });
    }

    render() {
        const {item, loading, form:{getFieldProps}, location:{query}} = this.props;

        const {isEdit} = this.state;

        const operation = (
            <div style={{textAlign:'right'}}>
                <Button.Group>
                    <Button type="ghost"
                            onClick={
                                e=>{
                                    e.preventDefault();
                                    this.props.dispatch({
                                        type: isEdit ? 'CANCEL_UPDATE_ANNOUNCEMENT' : 'UPDATE_ANNOUNCEMENT'
                                    });
                                }
                        }>
                        <Icon type="edit"/>
                    </Button>
                    <Button type="ghost" onClick={e=>{
                            e.preventDefault();
                            isEdit ?
                                this.props.dispatch({
                                    type: 'CANCEL_UPDATE_ANNOUNCEMENT'
                                }) :
                                this.props.history.goBack();
                        }}>
                        <Icon type="rollback"/>
                    </Button>
                </Button.Group>
            </div>
        );

        const breadcrumb = ['产品管理', '产品详情'];
        const titlePart = '公告详情';
        const title = (item && item.title ? item.title + ' - ' : '') + titlePart + (isEdit ? ' - 编辑' :'');

        breadcrumb.push(titlePart);

        const header = (
            <MainHeader breadcrumb={breadcrumb} title={title} operation={operation}/>
        );

        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    {
                        item &&
                        <Form className="main-form" horizontal onSubmit={this.handleSubmit.bind(this)}>
                            <Form.Item label="标题" {...formItemLayout}>
                                {
                                    isEdit ?
                                        <Input placeholder="公告标题"
                                            {...getFieldProps('title', {
                                                initialValue: item.title
                                            })}  />
                                        :
                                        item.title
                                }

                            </Form.Item>
                            <Form.Item label="内容" {...formItemLayout}>
                                {
                                    isEdit ?
                                        <Input placeholder="公告内容" autosize={{ minRows: 5 }} type="textarea"
                                            {...getFieldProps('announcement', {
                                                initialValue: item.announcement
                                            })}  />
                                        :
                                        <p style={{maxWidth:500}} {...innerHTML(item.announcement, true)} />
                                }
                            </Form.Item>
                            <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                                {
                                    isEdit ?
                                        <Button type="primary" onClick={this.handleSubmit.bind(this)}
                                                loading={loading}>
                                            <Icon type="save"/>保存
                                        </Button>
                                        :
                                        <Button type="primary" onClick={e=>{
                                            e.preventDefault();
                                            this.props.dispatch({
                                                type:'UPDATE_ANNOUNCEMENT'
                                            });
                                        }}>
                                            <Icon type="edit"/>编辑
                                        </Button>

                                }
                                <Button onClick={e=>{
                                            e.preventDefault();
                                            isEdit ?
                                                this.props.dispatch({
                                                    type: 'CANCEL_UPDATE_ANNOUNCEMENT'
                                                }) :
                                                this.props.history.goBack();
                                        }}
                                        style={{marginLeft:'1em'}}>
                                    <Icon type="rollback"/>
                                    {isEdit ? '取消' : '返回'}
                                </Button>
                            </Form.Item>
                        </Form>
                    }
                </Spin>
            </Layout>
        );
    }
}
