import React, {Component, PropTypes} from 'react';
import {Button, Icon, Form} from 'antd';

import {footerFormSubmitLayout} from '../../utils';

export default class FooterOperation extends Component {

    static propTypes = {
        isEdit: PropTypes.bool,
        command: PropTypes.string,
        dispatch: PropTypes.func,
        history: PropTypes.object,
        layout: PropTypes.object,
        beforeButtons: PropTypes.node,
        afterButtons: PropTypes.node
    };

    render() {
        const {isEdit, hasCancel=true, command, dispatch, history, loading, layout, beforeButtons, afterButtons} = this.props;
        const UPDATE_COMMAND = 'UPDATE_' + command;
        const CANCEL_UPDATE_COMMAND = 'CANCEL_' + UPDATE_COMMAND;
        const handleEditBtnClick = e => {
            e.preventDefault();
            dispatch({
                type: UPDATE_COMMAND
            });
        };
        const handleRollbackBtnClick = e => {
            e.preventDefault();
            isEdit ? dispatch({type: CANCEL_UPDATE_COMMAND}) : history.goBack();
        };
        return (
            <Form.Item {...footerFormSubmitLayout} {...layout} style={{marginTop:30}}>
                {beforeButtons}
                {
                    isEdit ?
                        <Button type="primary" htmlType="submit" loading={loading}>
                            <Icon type="save"/>保存
                        </Button>
                        :
                        <Button type="primary" onClick={handleEditBtnClick}>
                            <Icon type="edit"/>编辑
                        </Button>
                }
                {
                    hasCancel &&
                    <Button onClick={handleRollbackBtnClick} style={{marginLeft:'1em'}}>
                        <Icon type="rollback"/>{isEdit ? '取消' : '返回'}
                    </Button>
                }
                {afterButtons}
            </Form.Item>
        );
    }
}
