import {takeLatest} from 'redux-saga';
import {take, call, put, fork, cancel, select} from 'redux-saga/effects';
import {message} from 'antd';

export default class RESTful {
    constructor() {

    }

    index() {
        const {api, id} = this;
        return function*(query) {
            try {
                const result = yield call(api.index, query);
                yield put({
                    type: 'FETCH_' + id + '_LIST_SUCCESS',
                    result
                });
            } catch (err) {
                console.log(err);
                message.error(err);
                yield put({
                    type: 'FETCH_' + id + '_LIST_FAILED',
                    err,
                });
            }
        }
    }

    show() {
        const {api, id} = this;
        return function*(id) {
            try {
                const result = yield call(api.show, id);
                yield put({
                    type: 'FETCH_' + id + '_ITEM_SUCCESS',
                    result
                });
            } catch (err) {
                console.log(err);
                message.error(err);
                yield put({
                    type: 'FETCH_' + id + '_ITEM_FAILED',
                    err
                });
            }
        }
    }

    create() {
        const {api, id} = this;
        return function*(data) {
            try {
                const result = yield call(api.create, data);
                yield put({
                    type: 'CREATE_' + id + '_ITEM_SUCCESS',
                    result
                });
            } catch (err) {
                console.log(err);
                message.error(err);
                yield put({
                    type: 'CREATE_' + id + '_ITEM_FAILED',
                    err
                });
            }
        }
    }
}
