import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';

import {
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    userStatusToString,
    formatDateTime,
    NULL
} from '../../utils';

import {
    STATUS_LIST,
    statusToString
} from './utils';


@connect(state=>({
    loading: state.resource.loading,
    item: state.resource.item,
    isEdit: state.resource.isEdit
}))
@Form.create()
export default class EditItem extends Component {
    constructor() {
        super(...arguments);
        this.state = {
            isEdit: false
        }
    }


    componentDidMount() {
        this.fetchItem(this.props.params.id);
    };

    componentWillReceiveProps(nextProps) {
        this.setState({isEdit: nextProps.isEdit});
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_RESOURCE_ITEM',
            id
        });
    };

    handleSubmit(e) {
        e.preventDefault();
        let data = {};
        data = this.props.form.getFieldsValue();
        data.id = this.props.params.id;
        if (isNaN(data.status)) {
            STATUS_LIST.forEach(item=> {
                if (item.text === data.status) {
                    data.status = item.value
                }
            })
        }
        console.log(data);
        this.props.dispatch({
            type: 'UPDATE_RESOURCE_ITEM',
            item: data
        });
    }

    render() {
        const {item, loading, form:{getFieldProps}, location:{query}} = this.props;

        const {isEdit} = this.state;

        const operation = (
            <div style={{textAlign:'right'}}>
                <Button.Group>
                    <Button type="ghost"
                            onClick={
                            e=>{
                                e.preventDefault();
                                this.props.dispatch({
                                    type: isEdit ? 'CANCEL_UPDATE_RESOURCE' : 'UPDATE_RESOURCE'
                                });
                            }
                    }>
                        <Icon type="edit"/>
                    </Button>
                    <Button type="ghost" onClick={e=>{
                        e.preventDefault();
                        isEdit ?
                            this.props.dispatch({
                                type: 'CANCEL_UPDATE_PRODUCT'
                            }) :
                            this.props.history.goBack();
                    }}>
                        <Icon type="rollback"/>
                    </Button>
                </Button.Group>
            </div>
        );

        const header = (
            <MainHeader breadcrumb={['权限管理', '权限资源详情']}
                        title={'权限资源详情' + (isEdit ? ' - 编辑' : '')}
                        operation={operation}
            />
        );

        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    {
                        item &&
                        <Form className="main-form" horizontal>

                            <Form.Item label="分组" {...smallFormItemLayout}>
                                {
                                    isEdit ?
                                        <Input {...getFieldProps('category', {initialValue: item.category})} />
                                        :
                                    item.category || NULL
                                }
                            </Form.Item>
                            <Form.Item label="描述" {...smallFormItemLayout}>
                                {
                                    isEdit ?
                                        <Input {...getFieldProps('description', {initialValue: item.description})} />
                                        :
                                    item.description || NULL
                                }
                            </Form.Item>
                            <Form.Item label="状态" {...smallFormItemLayout}>
                                {
                                    isEdit ?
                                        <Select
                                            placeholder="请选择状态" {...getFieldProps('status', {initialValue: statusToString(item.status)})} >
                                            <Select.Option value="1">系统</Select.Option>
                                            <Select.Option value="5">禁用</Select.Option>
                                            <Select.Option value="9">启用</Select.Option>
                                        </Select>
                                        :
                                        (typeof item.status !== 'undefined' ? statusToString(item.status) : NULL)
                                }
                            </Form.Item>

                            <Form.Item label="method" {...smallFormItemLayout}>
                                { item.httpMethod }
                            </Form.Item>
                            <Form.Item label="url" {...smallFormItemLayout}>
                                { item.url }
                            </Form.Item>
                            <Form.Item label="controllerName" {...smallFormItemLayout}>
                                { item.controllerName }
                            </Form.Item>
                            <Form.Item label="actionName" {...smallFormItemLayout}>
                                { item.actionName }
                            </Form.Item>
                            <Form.Item label="注册时间" {...smallFormItemLayout}>
                                {item.dateCreated && formatDateTime(item.dateCreated)}
                            </Form.Item>
                            <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                                {
                                    isEdit ?
                                        <Button type="primary" onClick={this.handleSubmit.bind(this)}
                                                loading={loading}>
                                            <Icon type="save"/>保存
                                        </Button>
                                        :
                                        <Button type="primary" onClick={e=>{
                                            e.preventDefault();
                                            this.props.dispatch({
                                                type:'UPDATE_RESOURCE'
                                            });
                                        }}>
                                            <Icon type="edit"/>编辑
                                        </Button>

                                }
                                <Button onClick={e=>{
                                            e.preventDefault();
                                            isEdit ?
                                                this.props.dispatch({
                                                    type: 'CANCEL_UPDATE_RESOURCE'
                                                }) :
                                                this.props.history.goBack();
                                        }}
                                        style={{marginLeft:'1em'}}>
                                    <Icon type="rollback"/>
                                    {isEdit ? '取消' : '返回'}
                                </Button>
                            </Form.Item>
                        </Form>
                    }
                </Spin>
            </Layout>
        );
    }
}


