import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';

import {
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    userStatusToString,
    formatDateTime,
    NULL,
    ACTIONPERMISSION
} from '../../utils';


@connect(state=>({
    loading: state.authority.loading || state.resource.loading,
    item: state.authority.item,
    isEdit: state.authority.isEdit,
    resources: state.resource.items,
    resourcesTotal: state.resource.total
}))
@Form.create()
export default class EditItem extends Component {
    constructor() {
        super(...arguments);
        this.state = {
            isEdit: false
        }
    }


    componentDidMount() {
        this.fetchItem(this.props.params.id);
        this.fetchResourceList();
    };

    componentWillReceiveProps(nextProps) {
        this.setState({isEdit: nextProps.isEdit});
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_AUTHORITY_ITEM',
            id
        });
    };

    fetchResourceList() {
        this.props.dispatch({
            type: 'FETCH_RESOURCE_LIST'
        });
    };

    handleSubmit(e) {
        e.preventDefault();
        let data = {};
        data = this.props.form.getFieldsValue();
        data.id = this.props.params.id;
        // if (isNaN(data.status)) {
        //     STATUS_LIST.forEach(item=> {
        //         if (item.text === data.status) {
        //             data.status = item.value
        //         }
        //     })
        // }
        console.log(data);
        this.props.dispatch({
            type: 'UPDATE_AUTHORITY_ITEM',
            item: data
        });
    }

    render() {
        const {item, resources, loading, form:{getFieldProps}, location:{query}} = this.props;

        const {isEdit} = this.state;

        const operation = (
            <div style={{textAlign:'right'}}>
                <Button.Group>
                    <Button type="ghost"
                            onClick={
                            e=>{
                                e.preventDefault();
                                this.props.dispatch({
                                    type: isEdit ? 'CANCEL_UPDATE_AUTHORITY' : 'UPDATE_AUTHORITY'
                                });
                            }
                    }>
                        <Icon type="edit"/>
                    </Button>
                    <Button type="ghost" onClick={e=>{
                        e.preventDefault();
                        isEdit ?
                            this.props.dispatch({
                                type: 'CANCEL_UPDATE_PRODUCT'
                            }) :
                            this.props.history.goBack();
                    }}>
                        <Icon type="rollback"/>
                    </Button>
                </Button.Group>
            </div>
        );

        const header = (
            <MainHeader breadcrumb={['权限管理', '角色详情']}
                        title={'角色详情' + (isEdit ? ' - 编辑' : '')}
                        operation={operation}
            />
        );

        const resourcesMap = {};
        resources.forEach(item=> {
            resourcesMap[item.controllerName] = {category: item.category};
        });


        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    {
                        item &&
                        <Form className="main-form" horizontal>

                            <Form.Item label="角色名" {...smallFormItemLayout}>
                                {
                                    isEdit ?
                                        <Input {...getFieldProps('name', {initialValue: item.name})} />
                                        :
                                    item.name || NULL
                                }
                            </Form.Item>
                            <Form.Item label="描述" {...smallFormItemLayout}>
                                {
                                    isEdit ?
                                        <Input {...getFieldProps('description', {initialValue: item.description})} />
                                        :
                                    item.description || NULL
                                }
                            </Form.Item>
                            <Form.Item label="状态" {...smallFormItemLayout}>
                                {
                                    // isEdit ?
                                    //     <Select
                                    //         placeholder="请选择状态" {...getFieldProps('status', {initialValue: statusToString(item.status)})} >
                                    //         <Select.Option value="1">系统</Select.Option>
                                    //         <Select.Option value="5">禁用</Select.Option>
                                    //         <Select.Option value="9">启用</Select.Option>
                                    //     </Select>
                                    //     :
                                    //     (typeof item.status !== 'undefined' ? statusToString(item.status) : NULL)
                                }
                            </Form.Item>

                            <Form.Item label="创建时间" {...smallFormItemLayout}>
                                {item.dateCreated && formatDateTime(item.dateCreated)}
                            </Form.Item>

                            <Form.Item label="">
                                {
                                    Object.keys(resourcesMap).map((resource, index)=>
                                        <div key={'resource-'+index}>{JSON.stringify(resource)}</div>
                                    )
                                }
                            </Form.Item>

                            <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                                {
                                    isEdit ?
                                        <Button type="primary" onClick={this.handleSubmit.bind(this)}
                                                loading={loading}>
                                            <Icon type="save"/>保存
                                        </Button>
                                        :
                                        <Button type="primary" onClick={e=>{
                                            e.preventDefault();
                                            this.props.dispatch({
                                                type:'UPDATE_AUTHORITY'
                                            });
                                        }}>
                                            <Icon type="edit"/>编辑
                                        </Button>

                                }
                                <Button onClick={e=>{
                                            e.preventDefault();
                                            isEdit ?
                                                this.props.dispatch({
                                                    type: 'CANCEL_UPDATE_AUTHORITY'
                                                }) :
                                                this.props.history.goBack();
                                        }}
                                        style={{marginLeft:'1em'}}>
                                    <Icon type="rollback"/>
                                    {isEdit ? '取消' : '返回'}
                                </Button>
                            </Form.Item>
                        </Form>
                    }
                </Spin>
            </Layout>
        );
    }
}


