import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Table, Icon} from 'antd';
import {Link} from 'react-router';
import {serialize, formatDateTime, remittanceAuditStatusToString} from '../../utils';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader';

const columns = [
    {
        title: 'ID',
        dataIndex: 'id',
        key: 'id',
        width: 70
    }, {
        title: '提款人',
        dataIndex: 'bankCard',
        key: 'bankCard',
        render: (bankCard, record)=>(<span>{bankCard.userName}</span>)
    }, {
        title: '提现金额',
        dataIndex: 'amount',
        key: 'amount',
        width: 100,
        className: 'tac',
    }, {
        title: '申请时间',
        dataIndex: 'dateCreated',
        key: 'dateCreated',
        width: 150,
        className: 'tac',
        render: (dateCreated, record)=>(
            <span>
                {dateCreated && formatDateTime(dateCreated)}
            </span>
        )
    }, {
        title: '状态',
        dataIndex: 'status',
        key: 'status',
        width: 120,
        className: 'tac',
        render: (status, record)=>(<span data-status={status}>{remittanceAuditStatusToString(status)}</span>)
    }, {
        title: '操作',
        key: 'operation',
        width: 60,
        // fixed:'right',
        className: 'tac',
        render: (text, record)=>(
            <span>
                {
                    record.status == 1 &&
                    <Link to={'/withdraw/audits/'+ record.id} onClick={e=>e.stopPropagation()}>审核</Link>
                }
            </span>

        )
    }
];

@connect(state=>({
    items: state.withdraw.audits,
    loading: state.withdraw.loading,
    total: state.withdraw.total,
}))
export default class List extends Component {

    constructor(props, context) {
        super(props, context);

    }

    componentDidMount() {
        this.fetchList(this.props.location.query);
    };

    fetchList(query) {
        this.props.dispatch({
            type: 'FETCH_WITHDRAW_LIST',
            query
        });
    }

    handleRowClick({id}) {
        this.props.history.push('/withdraw/audits/' + id);
    }

    render() {

        const {total, items, loading, history:{replace}, location:{pathname, query}} = this.props;

        const pagination = {
            total: total,
            pageSize: parseInt(query.s, 10) || 10,
            current: parseInt(query.p, 10) || 1,
            showSizeChanger: true,
            onShowSizeChange: (current, pageSize)=> {
                console.log('Current: ', current, '; PageSize: ', pageSize);
                query.p = current;
                query.s = pageSize;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            },
            onChange: (current) => {
                console.log('Current: ', current);
                query.p = current;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            }
        };

        const header = (<MainHeader breadcrumb={['审核管理', '提现审核']}
                                    title="提现审核列表"/>);

        return (
            <Layout header={header}>
                <Table className="ant-table" columns={columns}
                       dataSource={Array.isArray(items) ? items : []}
                       loading={loading}
                       pagination={pagination}
                       scroll={{y: window.innerHeight - 380}}
                       onRowClick={this.handleRowClick.bind(this)}
                />
            </Layout>
        );
    }
}



