import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Copy from '../../components/CopyToClipboard/CopyToClipboard';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader';

import {
    handleUpload
} from '../../utils';

@connect(state=>({
    user: state.user
}))
@Form.create()
export default class BaseUpload extends Component {
    constructor(props, context) {
        super(props, context);
        this.state = {
            fileList: []
        };
    }

    render() {
        const {user} = this.props;
        const styles = require('./BaseUpload.less');

        const header = (<MainHeader breadcrumb={['基本功能', '图片上传']} title="图片上传"/>);

        return (
            <Layout header={header}>
                <Row>
                    <Col span="24">
                        <Upload.Dragger action="/api/fileUpload/upload"
                                        multiple={true}
                                        headers={{
                                authorization: user && user.token,
                            }}
                                        onChange={info=>this.setState({fileList: handleUpload(info)})}
                                        showUploadList={false}
                                        onPreview={(e)=>console.log(e)}
                        >
                            <p className="ant-upload-drag-icon">
                                <Icon type="inbox"/>
                            </p>
                            <p className="ant-upload-text">点击或将图片拖拽到此区域上传</p>
                            <p className="ant-upload-hint">支持单个或批量上传，严禁上传公司内部资料及其他违禁文件</p>
                        </Upload.Dragger>
                        <ul className={styles.fileList}>
                            {
                                this.state.fileList.map(file=>
                                    <li key={file.uid}>
                                        <Copy copyText={file.url}>
                                            <Row>
                                                <Col span="4"><Icon type="paper-clip"
                                                                    style={{marginRight:'.3em'}}/>{file.name}</Col>
                                                <Col span="20">{file.url ? file.url : '正在上传...'}</Col>
                                            </Row>
                                        </Copy>
                                    </li>
                                )
                            }
                        </ul>
                    </Col>
                </Row>
            </Layout>
        );
    }
}
