import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Breadcrumb
} from 'antd';


export default class MainHeader extends Component {
    static propType = {
        breadcrumb: PropTypes.array,
        title: PropTypes.node
    };

    render() {

        const {breadcrumb, title, operation} = this.props;

        return (
            <div className="main-header">
                <Row >
                    <Col span="8">
                        <Breadcrumb>
                            { breadcrumb.map((b, i)=><Breadcrumb.Item key={i}>{b}</Breadcrumb.Item>) }
                        </Breadcrumb>
                    </Col>
                </Row>
                <Row type="flex" justify="space-around" align="middle">
                    <Col span="20">
                        <h1 className="tac">{title}</h1>
                    </Col>
                    {
                        operation &&
                            <Col span="4">
                                {operation}
                            </Col>
                    }
                </Row>
            </div>
        );
    }
}
