import {handleActions} from 'redux-actions';
import {combineReducer} from 'redux';

const resources = handleActions({
    ['FETCH_RESOURCE_LIST'](state) {
        return {...state, loading: true};
    },
    ['FETCH_RESOURCE_LIST_SUCCESS'](state, action) {
        return {...state, loading: false, items: action.items, total: action.total};
    },
    ['FETCH_RESOURCE_LIST_FAILED'](state, action) {
        return {...state, err: action.err, loading: false};
    },
    ['FETCH_RESOURCE_ITEM'](state) {
        return {...state, loading: true};
    },
    ['FETCH_RESOURCE_ITEM_SUCCESS'](state, action) {
        return {...state, loading: false, item: action.item};
    },
    ['FETCH_RESOURCE_ITEM_FAILED'](state, action) {
        return {...state, err: action.err, loading: false};
    },

    ['UPDATE_RESOURCE_START'](state){
        return {...state, isEdit: true}
    },
    ['UPDATE_RESOURCE_END'](state){
        return {...state, isEdit: false}
    },
    ['UPDATE_RESOURCE_ITEM'](state){
        return {...state, loading: true}
    },
    ['UPDATE_RESOURCE_ITEM_SUCCESS'](state, action){
        return {...state, loading: false, item: {...state.item, ...action.item}}
    },
    ['UPDATE_RESOURCE_ITEM_FAILED'](state, action){
        return {...state, err: action.err, loading: false}
    },
}, {
    items: [],
    loading: false,
});


export default resources;
