import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Table, Icon} from 'antd';
import {Link} from 'react-router';
import {serialize, formatDateTime, remittanceAuditStatusToString} from '../../utils';
import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';

const columns = [
    {
        title: 'ID',
        dataIndex: 'id',
        key: 'id',
        width: 70
    }, {
        title: '产品',
        dataIndex: 'itemShortTitle',
        key: 'itemShortTitle',

        render: (shortTitle, record)=>(<span title={shortTitle}>{(shortTitle + '').substring(0, 20)}</span>)
    }, {
        title: '投资人',
        dataIndex: 'buyerName',
        key: 'buyerName',
        width: 100,
        className: 'tac',
    }, {
        title: '预约额度',
        dataIndex: 'reservationAmount',
        key: 'reservationAmount',
        width: 80,
        className: 'tac',
    }, {
        title: '报单时间',
        dataIndex: 'submitReceiptTime',
        key: 'submitReceiptTime',
        width: 150,
        className: 'tac',
        render: (submitReceiptTime, record)=>(
            <span>
                {submitReceiptTime && formatDateTime(submitReceiptTime)}
            </span>
        )
    }, {
        title: '状态',
        dataIndex: 'status',
        key: 'status',
        width: 120,
        className: 'tac',
        render: (status, record)=>(<span data-status={status}>{remittanceAuditStatusToString(status)}</span>)
    }, {
        title: '操作',
        key: 'operation',
        width: 60,
        // fixed:'right',
        className: 'tac',
        render: (text, record)=>(
            <span>
                {
                    record.status == 1 &&
                    <Link to={'/remittance/audits/'+ record.id} onClick={e=>e.stopPropagation()}>审核</Link>
                }
            </span>

        )
    }
];

@connect(state=>({
    items: state.remittance.audits,
    loading: state.remittance.loading,
    total: state.remittance.total,
}))
export default class List extends Component {

    constructor(props, context) {
        super(props, context);
        this.state = {
            filterVisible: false
        }
    }

    componentDidMount() {
        this.fetchList(this.props.location.query);
    };

    fetchList(query) {
        this.props.dispatch({
            type: 'FETCH_REMITTANCE_LIST',
            query
        });
    }

    handleRowClick({id}) {
        this.props.history.push('/remittance/audits/' + id);
    }

    render() {

        const {total, items, loading, history:{replace}, location:{pathname, query}} = this.props;

        const pagination = {
            total: total,
            pageSize: parseInt(query.s, 10) || 30,
            current: parseInt(query.p, 10) || 1,
            showSizeChanger: true,
            showTotal: total => `共 ${total} 条`,
            pageSizeOptions:['10', '30', '50', '100'],
            onShowSizeChange: (current, pageSize)=> {
                console.log('Current: ', current, '; PageSize: ', pageSize);
                query.p = current;
                query.s = pageSize;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            },
            onChange: (current) => {
                console.log('Current: ', current);
                query.p = current;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            }
        };

        const header = (<MainHeader breadcrumb={['审核管理', '报单审核']}
                                    title="报单审核列表"/>);

        return (
            <Layout header={header}>
                <Table className="list-table" columns={columns}
                       dataSource={Array.isArray(items) ? items : []}
                       loading={loading}
                       pagination={pagination}
                       scroll={{ y: window.innerHeight-(this.state.filterVisible? 203 :150) }}
                       onRowClick={this.handleRowClick.bind(this)}
                />
            </Layout>
        );
    }
}



