import React, {Component, PropTypes} from 'react';
import {Router, Route, IndexRoute, Link} from 'react-router';
import Layout from '../../components/Layout/Layout';
import {connect} from 'react-redux';

import {Collapse, Menu, Icon, Upload, Row, Col} from 'antd';
const Panel = Collapse.Panel;

const SubMenu = Menu.SubMenu;
const MenuItemGroup = Menu.ItemGroup;

@connect(state=>({
    user: state.user
}))
export default class App extends Component {
    static propTypes = {
        children: PropTypes.object.isRequired,
    };

    static contextTypes = {
        store: PropTypes.object.isRequired
    };

    render() {
        const styles = require('./App.less');
        const menu = [
            {
                id:'business',
                title: '业务管理',
                icon: 'mail',
                items: [
                    {
                        title: '产品管理',
                        items: [
                            {
                                to: '/products',
                                cn: '产品列表',
                                en: 'Products'
                            }, {
                                to: '/products/create',
                                cn: '添加产品',
                                en: 'Add Products'
                            }
                        ]
                    }, {
                        title: '订单管理',
                        items: [
                            {
                                to: '/trades',
                                cn: '订单列表',
                                en: 'Trades'
                            }
                        ]
                    }, {
                        title: '审核管理',
                        items: [
                            {
                                to: '/remittance/audits',
                                cn: '报单审核',
                                en: 'Remittance Audits'
                            }, {
                                to: '/withdraw/audits',
                                cn: '提现审核',
                                en: 'Withdraw Money'
                            }
                        ]
                    }, {
                        title: '消息管理',
                        items: [
                            {
                                to: '/customMessages',
                                cn: '消息列表',
                                en: 'Messages'
                            }, {
                                to: '/customMessages/create',
                                cn: '推送消息',
                                en: 'Send Message'
                            }
                        ]
                    }
                ]
            }, {
                id:'base',
                title: '基础功能',
                icon: 'folder',
                items: [
                    {
                        title: '文件管理',
                        items: [
                            {
                                to: '/upload',
                                cn: '图片上传',
                                en: 'Upload Images'
                            }
                        ]
                    }
                ]
            }, {
                id:'admin',
                title: '管理员',
                icon: 'folder',
                items: [
                    {
                        title: '用户管理',
                        items: [
                            {
                                to: '/admin/users',
                                cn: '用户列表',
                                en: 'Users'
                            }, {
                                to: '/admin/users/create',
                                cn: '创建用户',
                                en: 'Create user'
                            }
                        ]
                    }, {
                        title: '权限管理',
                        items: [
                            {
                                to: '/admin/resources',
                                cn: '权限资源列表',
                                en: ''
                            }, {
                                to: '/admin/authorities',
                                cn: '角色列表',
                                en: 'Authorities'
                            }
                        ]
                    }
                ]
            }];

        const {user, location:{pathname}} = this.props;

        const logo = require('./images/logo.png');

        const openKey = '';

        return (
            <div className={styles.content}>
                <div className={styles.side}>
                    <header>
                        <img className="page-logo" src={'/'+logo} title="枢纽科技" alt="枢纽科技"/>
                    </header>
                    <section>
                        <Menu mode="inline" defaultOpenKeys={['sub1']}>
                            {user && user.token &&
                            menu.map((submenu, si)=>
                                <SubMenu key={'submenu'+si} title={
                                    <span><Icon type={submenu.icon} /><span>{submenu.title}</span></span>
                                }>
                                    {submenu.items.map((menus, mi)=>
                                        <MenuItemGroup key={'menu-item-group-'+si+'-'+ mi} title={menus.title}>
                                            {menus.items.map((item, ii)=>
                                                <Menu.Item key={[si, mi,ii].join('-')}>
                                                    <MenuItemContent {...item}/>
                                                </Menu.Item>
                                            )}
                                        </MenuItemGroup>
                                    )}
                                </SubMenu>
                            )}
                        </Menu>
                    </section>
                    <footer>
                        杭州枢纽科技有限公司
                    </footer>
                </div>
                <div className={styles.main}>
                    {user && user.token && this.props.children}
                </div>
            </div>
        );
    }
}

class MenuItemContent extends Component {
    static propType = {
        to: PropTypes.string,
        cn: PropTypes.string,
        en: PropTypes.string,
    }

    render() {
        const {to, cn, en} = this.props;
        return (
            <Link to={to}>
                <span>
                    <span className="cn">{cn}</span>
                    <span className="en">{en}</span>
                </span>
            </Link>
        );
    }
}


// <div className={styles.head}>
//     <Row type="flex" justify="space-around" align="middle" style={{height:'100%'}}>
//         <Col span="12">
//             <img className="page-logo" src={'/'+logo} title="枢纽科技" alt="枢纽科技"/>
//         </Col>
//         <Col span="12">
//             <div style={{float:'right', marginRight:30}}>
//                 {user.username}
//             </div>
//         </Col>
//     </Row>
// </div>

// <div className={styles.foot}>
//     杭州枢纽科技有限公司 荣誉出品 <a href="mailto:bainx@vip.qq.com">问题反馈</a>
// </div>


//<div className={styles.normal}></div>


// <SubMenu key="sub1" title={<span><Icon type="mail" /><span>业务管理</span></span>}>
//     {
//         user && user.token &&
//         mainMenu.map((menu, mi)=>
//             <MenuItemGroup title={menu.title} key={mi}>
//                 {
//                     menu.items.map((item, ii)=>
//                         <Menu.Item key={[mi,ii].join('-')}>
//                             <MenuItemContent {...item}/>
//                         </Menu.Item>
//                     )
//                 }
//             </MenuItemGroup>
//         )
//     }
// </SubMenu>
// <SubMenu key="sub2" title={<span><Icon type="folder" /><span>基本功能</span></span>}>
// <Menu.Item>
// <MenuItemContent to="/upload" cn="图片上传" en="Upload Images"/>
//     </Menu.Item>
//     </SubMenu>
//     <SubMenu key="sub3" title={<span><Icon type="folder" /><span>管理员</span></span>}>
// <MenuItemGroup title='用户管理' key='users'>
//     <Menu.Item>
//     <MenuItemContent to="/admin/users" cn="用户列表" en="Users"/>
//     </Menu.Item>
//     <Menu.Item>
//     <MenuItemContent to="/admin/users/create" cn="创建用户" en="Create users"/>
//     </Menu.Item>
//     </MenuItemGroup>
//     </SubMenu>





