import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import {
    arrayRemoveIndex,
    UUID,
    NULL,
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    handleUpload,
    FILE_UPLOAD
} from '../../utils';
import Copy from '../../components/CopyToClipboard/CopyToClipboard';


@Form.create()
export default class DocumentsForm extends Component {
    constructor(props, context) {
        super(props, context);
        this.state = {
            fileList: props.product.documents.map(file=> {
                file.uid = UUID();
                file.url = file.file;
                file.status = 'done';
                return file;
            })
        };

    }

    static propsType = {
        product: PropTypes.object,

    };

    componentWillMount() {

    }

    handleSubmit(e) {
        e.preventDefault();
        const files = [];
        this.state.fileList.forEach(file=> {
            files.push({
                name: file.name,
                file: file.url
            });
        });
        const data = {
            id: this.props.product.id,
            documents: JSON.stringify(files)
        };

        console.log(data);

        this.props.dispatch({
            type: 'UPDATE_PRODUCT_ITEM',
            item: data
        });
    }

    render() {
        const {user, loading, isEdit} = this.props;
        return (
            <Spin spinning={loading}>
                <Form horizontal onSubmit={this.handleSubmit.bind(this)} style={{maxWidth:'800px', margin:'auto'}}>
                    <Row style={{padding:'0 20px'}}>
                        <Col span="24">
                            <Form.Item>
                                {
                                    isEdit ?
                                        <Upload.Dragger {...FILE_UPLOAD}
                                            multiple={true}
                                            headers={{
                                                    authorization: user && user.token,
                                                }}
                                            onChange={info=>this.setState({fileList: handleUpload(info)})}
                                            //showUploadList={false}
                                            onPreview={(e)=>console.log(e)}
                                            fileList={this.state.fileList}
                                        >
                                            <p className="ant-upload-drag-icon">
                                                <Icon type="inbox"/>
                                            </p>
                                            <p className="ant-upload-text">点击或将文件拖拽到此区域上传</p>
                                            <p className="ant-upload-hint">支持单个或批量上传，严禁上传公司内部资料及其他违禁文件</p>
                                        </Upload.Dragger>
                                        :
                                        <ul style={{paddingTop:30}}>
                                            {
                                                this.state.fileList.map(file=>
                                                    <li key={file.uid} style={{margin:"10px 0"}}>
                                                        <Copy copyText={file.url}>
                                                            <Row>
                                                                <Col span="4"><Icon type="paper-clip"
                                                                                    style={{marginRight:'.3em'}}/>{file.name}
                                                                </Col>
                                                                <Col span="20">{file.url ? file.url : '正在上传...'}</Col>
                                                            </Row>
                                                        </Copy>
                                                    </li>
                                                )
                                            }
                                        </ul>
                                }
                            </Form.Item>
                            <Form.Item style={{marginTop:30, textAlign:'center'}}>
                                <Button type="primary" htmlType="submit" loading={loading}><Icon
                                    type="save"/>保存</Button>
                                {
                                    !this.props.isCreate &&
                                    <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                            style={{marginLeft:'1em'}}>
                                        <Icon type="rollback"/>
                                        {isEdit ? '取消' : '返回'}
                                    </Button>
                                }
                            </Form.Item>
                        </Col>
                    </Row>
                </Form>
            </Spin>
        );
    }
}
