// export const params = query => Object.keys(query).map((key)=> {
//     return key + '=' + query[key];
// }).join('&');


export function serialize(obj, prefix) {
    var str = [];
    for (var p in obj) {
        if (obj.hasOwnProperty(p)) {
            var k = prefix ? prefix + "." + p : p, v = obj[p];
            if (typeof v !== 'undefined') {
                str.push(typeof v == "object" ?
                    serialize(v, k) :
                encodeURIComponent(k) + "=" + encodeURIComponent(v));
            }
        }
    }
    return str.join("&");
}


export const leftPad = num => {
    return num >= 10 ? num : ('0' + num);
};

export const formatDateTime = (time = 0, format = 'YYYY-MM-DD hh:mm:ss') => {
    const date = new Date(time);
    const data = {
        YYYY: date.getFullYear(),
        MM: leftPad(date.getMonth() + 1),
        DD: leftPad(date.getDate()),
        hh: leftPad(date.getHours()),
        mm: leftPad(date.getMinutes()),
        ss: leftPad(date.getSeconds())
    };
    return format.replace(/[A-Za-z]+/g, metch => {
        return data[metch];
    });
};

export const PRODUCT_STATUS = {
    '-9': '草稿',
    0: '已删除',
    1: '未发布',
    5: '预热中',
    11: '募集中',
    17: '已暂停',
    21: '已封账',
    31: '已成立',
}

export const productStatusToString = status => {
    return PRODUCT_STATUS[status] || '未定义';
};


export const tradeStatusToString = status => {
    switch (status) {
        case 1  :
            return '未报单，等待客户打款';
        case 10:
            return '已报单，等待验资';
        case 11:
            return '验资成功，等待项目成立';
        case 16:
            return '验资失败，资金未到账';
        case 12:
            return '待成立';
        case 21:
            return '项目已成立';
        case 22:
            return '项目成立';
        case 31:
            return '交易关闭';
        case 32:
            return '交易关闭';
        case 33:
            return '交易关闭';
        default:
            return '未定义';
    }
};

export const tradeCreateTypeToString = type => {
    switch (type) {
        case 1:
            return '后台创建';
        case 5:
            return 'APP创建';
        default:
            return '未知创建者';
    }
};

export const arrayRemoveIndex = (arr, index) => {
    return arr.concat(arr.splice(index).splice(1));
};

export const UUID = (()=> {
    let _UUID = 0;
    return ()=> {
        return _UUID++;
    }
})();

export function formatMoney(money = 0) {
    let ret;
    if (isNaN(money)) {
        ret = '0';
    } else if (money >= 1E10) {
        ret = (money / 1E10) + '亿';
    } else if (money >= 1E6) {
        ret = (money / 1E6) + '万';
    } else {
        ret = (money / 1E2);
    }
    return ret;
}
