import xFetch from './xFetch';
import {serialize} from '../utils';

export async function fetchList(query) {
    return xFetch('/api/announcement' + '?' + serialize(query));
}

export async function fetchItem(id) {
    return xFetch('/api/announcements/' + id);
}

export async function createItem(item) {
    return xFetch('/api/announcement/save', {
        method: 'POST',
        body: serialize(item)
    });
}
