import {takeLatest} from 'redux-saga';
import {take, call, put, fork, cancel, select} from 'redux-saga/effects';
import {fetchList, fetchItem} from '../services/trade';
import {message} from 'antd';

function* getList(query) {
    try {
        const {total, items} = yield call(fetchList, query);
        yield put({
            type: 'FETCH_TRADE_LIST_SUCCESS',
            total,
            items
        });
    } catch (err) {
        console.log(err);
        message.error(err);
        yield put({
            type: 'FETCH_TRADE_LIST_FAILED',
            err,
        });
    }
}

function* watchTradeList() {
    while (true) {
        const {query} = yield take('FETCH_TRADE_LIST');
        yield fork(getList, query);
    }
}

function* getItem(id) {
    try {
        const item = yield call(fetchItem, id);
        yield put({
            type: 'FETCH_TRADE_ITEM_SUCCESS',
            item
        });
    } catch (err) {
        console.log(err);
        message.error(err);
        yield put({
            type: 'FETCH_TRADE_ITEM_FAILED',
            err,
        });
    }
}

function* watchTradeItem() {
    while (true) {
        const {id} = yield take('FETCH_TRADE_ITEM');
        yield fork(getItem, id);
    }
}



export default function*() {
    yield fork(watchTradeList);
    yield fork(watchTradeItem);
}
