import React, {PropTypes, Component} from 'react';
import {Route, IndexRoute, Link} from 'react-router';
import Home from '../containers/Home/Home';
import NotFound from '../containers/NotFound/NotFound';
import Login from '../containers/Login/Login';
import App from '../containers/App/App';
import ProductList from '../containers/Product/List';
import ProductAddItem from '../containers/Product/AddItem';
import ProductEditItem from '../containers/Product/EditItem';
import ProductItem from '../containers/Product/Item';
import TradeList from '../containers/Trade/List';
import TradeItem from '../containers/Trade/Item';
import Commission from '../containers/Trade/Commission';
import Contract from '../containers/Trade/Contract';
import TradeAddItem from '../containers/Trade/AddItem';
import AnnouncementList from '../containers/Announcement/List';
import AnnouncementEditItem from '../containers/Announcement/EditItem';
import AnnouncementAddItem from '../containers/Announcement/AddItem';


export default (store)=> {
    const requireAuth = (nextState, replace, cb) => {
        const {user} = store.getState();
        if (!user || !user.token) {
            replace('/login');
        }
        cb();
    };
    return (
        <Route path="/">
            <Route onEnter={requireAuth} component={App}>
                <IndexRoute component={Home}/>
                <Route path="products"  >
                    <IndexRoute component={ProductList} />
                    <Route path="create" component={ProductAddItem} />
                    <Route path=":id" component={ProductItem} />
                    <Route path=":id/edit" component={ProductEditItem} />
                </Route>
                <Route path="trades" >
                    <IndexRoute component={TradeList} />
                    <Route path=":id" component={TradeItem} />
                    <Route path="commission/:id" component={Commission} />
                    <Route path="contract/:id" component={Contract} />
                    <Route path="create/:pid" component={TradeAddItem} />
                </Route>
                <Route path="announcement">
                    <IndexRoute component={AnnouncementList} />
                    <Route path="create" component={AnnouncementAddItem} />
                    <Route path=":id/edit" component={AnnouncementEditItem} />
                </Route>
                <Route path="/actived" component={Home}/>
                <Route path="/completed" component={Home}/>
            </Route>
            <Route path="/login" component={Login} />
            <Route path="*" component={NotFound}/>
        </Route>
    );
};

//
