import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Table, Icon} from 'antd';
import { Link } from 'react-router';
import {serialize, formatDateTime, tradeStatusToString} from '../../utils';


const columns = [
    {
        title: '订单ID',
        dataIndex: 'id',
        key: 'id',
        width:80,
        // fixed:'left'
    }, {
        title: '产品',
        dataIndex: 'shortTitle',
        key: 'shortTitle',

        render: (shortTitle, record)=>(<span title={shortTitle}>{(shortTitle + '').substring(0, 20)}</span>)
    }, {
        title: '预约时间',
        dataIndex: 'reservationTime',
        key: 'reservationTime',
        width:130,
        className:'tac',
        render: (reservationTime, record)=>(
            <span>
                {reservationTime && formatDateTime(reservationTime)}
            </span>
        )
    }, {
        title: '投资人',
        dataIndex: 'buyerName',
        key: 'buyerName',
        width:100,
        className:'tac',
    }, {
        title: '预约额度',
        dataIndex: 'reservationAmount',
        key: 'reservationAmount',
        width:100,
        className:'tac',
    }, {
        title: '实际打款',
        dataIndex: 'remittanceAmount',
        key: 'remittanceAmount',
        width:100,
        className:'tac',
    }, {
        title: '进度',
        dataIndex: 'status',
        key: 'status',
        width:150,
        className:'tac',
        render: (status, record)=>(<span data-status={status}>{tradeStatusToString(status)}</span>)
    }, {
        title: '操作',
        key: 'operation',
        width:140,
        // fixed:'right',
        className:'tac',
        render: (text, record)=>(
            <span>
                <Link to={'/trades/contract/'+ record.id} onClick={e=>e.stopPropagation()}>合同</Link>
                <span className="ant-divider"></span>
                <Link to={'/trades/commission/'+ record.id} onClick={e=>e.stopPropagation()}>佣金</Link>
            </span>
        )
    }
];

@connect(state=>({
    items: state.trade.items,
    loading: state.trade.loading,
    total: state.trade.total,
}))
export default class List extends Component {

    constructor(props, context) {
        super(props, context);

    }

    componentWillMount() {
        this.fetchList(this.props.location.query);
    };

    fetchList(query){
        this.props.dispatch({
            type: 'FETCH_TRADE_LIST',
            query
        });
    }

    handleRowClick({id}){
        this.props.history.push('/trades/'+id);
    }

    render() {

        const { total, items, loading, history:{replace}, location:{pathname, query}} = this.props;

        const pagination = {
            total: total,
            pageSize: parseInt(query.s, 10) || 10,
            current: parseInt(query.p, 10) || 1,
            showSizeChanger: true,
            onShowSizeChange: (current, pageSize)=> {
                console.log('Current: ', current, '; PageSize: ', pageSize);
                query.p = current;
                query.s = pageSize;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            },
            onChange: (current) => {
                console.log('Current: ', current);
                query.p = current;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            }
        };

        return <Table className="ant-table" columns={columns}
                      dataSource={Array.isArray(items)?items:[]}
                      loading={loading}
                      pagination={pagination}
                      scroll={{ y: window.innerHeight-245 }}
                      onRowClick={this.handleRowClick.bind(this)}
        />;
    }
}



