import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Form, Input, Button, Checkbox, message, Row, Col} from 'antd';


@connect(state=>({
    item: state.trade.item
}))
export default class Contract extends Component {

    componentWillMount() {
        const {dispatch, params:{id}} = this.props;
        dispatch({
            type: 'FETCH_TRADE_ITEM',
            id
        });
    };

    handleGoBack(e) {
        e.preventDefault();
        this.props.history.goBack();
    };

    handleSubmit(e){
        e.preventDefault();
        alert('实现保存物流订单号的流程');
    }


    render() {
        const {item} = this.props;
        const styles = require('./Item.less');
        const tw = 8;
        const vw = 16;

        return (
            <div className={styles.trade}>
                <h1 className="tac">合同物流</h1>
                <div className={styles.tradeTable}>
                    <Row type="flex" justify="space-around" align="middle">
                        <Col span={tw}>产品</Col>
                        <Col span={vw}>{item.title}</Col>
                    </Row>
                    <Row type="flex" justify="space-around" align="middle">
                        <Col span={tw}>确认打款金额</Col>
                        <Col span={vw}>{item.remittanceAmount}</Col>
                    </Row>
                    <Row type="flex" justify="space-around" align="middle">
                        <Col span={tw}>实际佣金</Col>
                        <Col span={vw}>{item.realReturn && item.realReturn.yj}</Col>
                    </Row>
                    <Row type="flex" justify="space-around" align="middle">
                        <Col span={tw} className="isRequire">顺丰运单</Col>
                        <Col span={vw}><Input placeholder="请填写顺丰运单编号" /></Col>
                    </Row>
                </div>
                <p>
                    <Button onClick={this.handleGoBack.bind(this)}>返回</Button>
                    <Button onClick={this.handleSubmit.bind(this)}>保存</Button>
                </p>
            </div>
        );
    }
}
