import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Form, Input, Button, Checkbox, message, Row, Col} from 'antd';


@connect(state=>({
    item: state.trade.item
}))
export default class Commission extends Component {

    componentWillMount() {
        const {dispatch, params:{id}} = this.props;
        dispatch({
            type: 'FETCH_TRADE_ITEM',
            id
        });
    };

    handleGoBack(e) {
        e.preventDefault();
        this.props.history.goBack();
    };

    handleCommission(e){
        e.preventDefault();
        alert('二次确认后发放');
    }

    render() {
        const {item} = this.props;
        const styles = require('./Item.less');
        const tw = 8;
        const vw = 16;

        return (
            <div className={styles.trade}>
                <h1 className="tac">佣金发放</h1>
                <div className={styles.tradeTable}>
                    <Row type="flex" justify="space-around" align="middle">
                        <Col span={tw}>产品</Col>
                        <Col span={vw}>{item.title}</Col>
                    </Row>
                    <Row type="flex" justify="space-around" align="middle">
                        <Col span={tw}>确认打款金额</Col>
                        <Col span={vw}>{item.remittanceAmount}</Col>
                    </Row>

                    <Row type="flex" justify="space-around" align="middle">
                        <Col span={tw}>实际佣金</Col>
                        <Col span={vw}>{item.realReturn && item.realReturn.yj}</Col>
                    </Row>
                </div>
                <p>
                    <Button onClick={this.handleGoBack.bind(this)}>返回</Button>
                    <Button onClick={this.handleCommission.bind(this)}>发放</Button>
                </p>
            </div>
        );
    }
}
