import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Form, Input, Button, Checkbox, message, Tabs, DatePicker, Upload, Icon, Modal} from 'antd';


@Form.create()
export default class AddItem extends Component {

    constructor() {
        super(...arguments);
        this.state = {
            priviewVisible: false,
            priviewImage: '',
        };
    }

    handleCancel() {
        this.setState({
            priviewVisible: false,
        });
    }

    render() {
        const formItemLayout = {
            labelCol: {span: 6},
            wrapperCol: {span: 14},
        };
        const props = {
            action: '/upload.do',
            listType: 'picture-card',
            defaultFileList: [{
                uid: -1,
                name: 'xxx.png',
                status: 'done',
                url: 'https://os.alipayobjects.com/rmsportal/NDbkJhpzmLxtPhB.png',
                thumbUrl: 'https://os.alipayobjects.com/rmsportal/NDbkJhpzmLxtPhB.png',
            }],
            onPreview: (file) => {
                this.setState({
                    priviewImage: file.url,
                    priviewVisible: true,
                });
            },
        };
        
        return (
            <div>
                <Form horizontal>

                    <Form.Item {...formItemLayout} label="产品">
                        <Input value={this.props.location.query.title} readOnly/>
                        <Input type="hidden"/>
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="理财师手机号">
                        <Input />
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="投资人姓名">
                        <Input />
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="投资人身份证号码">
                        <Input />
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="投资人身份证正反面照片">
                        <Upload {...props}>
                            <Icon type="plus"/>
                            <div className="ant-upload-text">上传照片</div>
                        </Upload>
                        <Modal visible={this.state.priviewVisible} footer={null}
                               onCancel={this.handleCancel.bind(this)}>
                            <img alt="example" src={this.state.priviewImage}/>
                        </Modal>
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="投资人实际打款金额">
                        <Input />
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="投资人实际打款时间">
                        <DatePicker showTime format="yyyy-MM-dd HH:mm:ss" placeholder="请选择时间"/>
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="投资人银行卡开户行">
                        <Input />
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="投资人银行卡照片">
                        <Upload {...props}>
                            <Icon type="plus"/>
                            <div className="ant-upload-text">上传照片</div>
                        </Upload>
                        <Modal visible={this.state.priviewVisible} footer={null}
                               onCancel={this.handleCancel.bind(this)}>
                            <img alt="example" src={this.state.priviewImage}/>
                        </Modal>
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="投资人打款凭条照片">
                        <Upload {...props}>
                            <Icon type="plus"/>
                            <div className="ant-upload-text">上传照片</div>
                        </Upload>
                        <Modal visible={this.state.priviewVisible} footer={null}
                               onCancel={this.handleCancel.bind(this)}>
                            <img alt="example" src={this.state.priviewImage}/>
                        </Modal>
                    </Form.Item>
                    <Form.Item {...formItemLayout} className="clearfix" label="投资人合同签字页照片">
                        <Upload {...props}>
                            <Icon type="plus"/>
                            <div className="ant-upload-text">上传照片</div>
                        </Upload>
                        <Modal visible={this.state.priviewVisible} footer={null}
                               onCancel={this.handleCancel.bind(this)}>
                            <img alt="example" src={this.state.priviewImage}/>
                        </Modal>
                    </Form.Item>
                    <Form.Item wrapperCol={{ span: 14, offset: 6 }}>
                        <Button type="primary" style={{marginRight:'1em'}}>提交</Button>
                        <Button onClick={(e)=>{e.preventDefault(); this.props.history.goBack();}}>返回</Button>
                    </Form.Item>
                </Form>
            </div>
        );
    }
}
