import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Table, Icon} from 'antd';
import {serialize, formatDateTime, productStatusToString} from '../../utils';
import {Link} from 'react-router';


const columns = [
    {
        title: 'ID',
        dataIndex: 'id',
        key: 'id',
        width: 60
    }, {
        title: '类目',
        dataIndex: 'cateId',
        key: 'cateId',
        width: 80,
        className:'tac',
        render: (cateId, record)=>(<span data-cate-id={cateId}>{record.cateName}</span>)
    }, {
        title: '标题',
        dataIndex: 'shortTitle',
        key: 'shortTitle',
        render: (shortTitle, record)=>(<span title={shortTitle}>{(shortTitle + '').substring(0, 20)}</span>)
    }, {
        title: '募集比率',
        dataIndex: 'rate',
        key: 'rate',
        width:120,
        className:'tac',
    }, {
        title: '状态',
        dataIndex: 'status',
        key: 'status',
        width:120,
        className:'tac',
        render: (status, record)=>(<span data-status={status}>{productStatusToString(status)}</span>)
    }, {
        title: '创建时间',
        dataIndex: 'dateCreated',
        key: 'dateCreated',
        width:150,
        className:'tac',
        render: (dateCreated, record)=>(
            <span>
                {dateCreated && formatDateTime(dateCreated)}
            </span>
        )
    }, {
        title: '操作',
        key: 'operation',
        width:120,
        className:'tac',
        render: (text, record)=>(
            <span>
                <a href={'/product/item?id='+ record.id}>详情</a>
                <span className="ant-divider"></span>
                <Link to={'/announcement?itemId='+record.id} onClick={e=>e.stopPropagation()}>公告</Link>
                <span className="ant-divider"></span>
                <Link to={'/trades/add/'+record.id+'?title='+record.shortTitle}>报单</Link>
            </span>
        )
    }
];

@connect(state=>({
    items: state.product.items,
    loading: state.product.loading,
    total: state.product.total
}))
export default class List extends Component {

    constructor(props, context) {
        super(props, context);

    }

    componentWillMount() {
        this.fetchList(this.props.location.query);
    };

    fetchList(query) {
        this.props.dispatch({
            type: 'FETCH_PRODUCT_LIST',
            query
        });
    };

    handleRowClick({id}){
        this.props.history.push('/products/'+id+'/edit');
    }


    render() {

        const {total, items, loading, history:{replace}, location:{pathname, query}} = this.props;


        const pagination = {
            total: total,
            pageSize: parseInt(query.s, 10) || 10,
            current: parseInt(query.p, 10) || 1,
            showSizeChanger: true,
            onShowSizeChange: (current, pageSize)=> {
                console.log('Current: ', current, '; PageSize: ', pageSize);
                query.p = current;
                query.s = pageSize;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            },
            onChange: (current)=> {
                console.log('Current: ', current);
                query.p = current;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            }
        };

        return <div>
            <h1>产品列表</h1>
            <Table className="ant-table" columns={columns}
                   dataSource={Array.isArray(items)?items:[]}
                   loading={loading}
                   pagination={pagination}
                   scroll={{ y: window.innerHeight-290 }}
                   onRowClick={this.handleRowClick.bind(this)}
            />
        </div>;
    }
}



