import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Link} from 'react-router';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

@connect(state=>({
    item: state.product.item,
    loading: state.product.loading
}))
export default class Item extends Component {

    componentWillMount() {
        this.fetchItem(this.props.params.id);
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_PRODUCT_ITEM',
            id
        });
    };

    handleGoBack(e) {
        e.preventDefault();
        this.props.history.goBack();
    };

    render() {
        const tw = 6;
        const vw = 18;
        const styles = require('../Trade/Item.less');
        const {item, loading} = this.props;
        return (
            <Spin spinning={loading}>
                {
                    item &&
                    <div className={styles.trade}>
                        <div className={styles.tradeTable}>
                            <Row type="flex" justify="space-around" align="middle">
                                <Col span={tw}>产品标题</Col>
                                <Col span={vw}>{item.itemTitle}</Col>
                            </Row>
                            <Row type="flex" justify="space-around" align="middle">
                                <Col span={tw}>产品短标题</Col>
                                <Col span={vw}>{item.itemShortTitle}</Col>
                            </Row>
                            <Row type="flex" justify="space-around" align="middle">
                                <Col span={tw}>产品标题</Col>
                                <Col span={vw}>{item.itemTitle}</Col>
                            </Row>
                            <Row type="flex" justify="space-around" align="middle">
                                <Col span={tw}>产品标题</Col>
                                <Col span={vw}>{item.itemTitle}</Col>
                            </Row>
                            <Row type="flex" justify="space-around" align="middle">
                                <Col span={tw}>产品标题</Col>
                                <Col span={vw}>{item.itemTitle}</Col>
                            </Row>
                        </div>
                        <p>
                            <Button onClick={this.handleGoBack.bind(this)}>返回</Button>
                            <Link to={'/products/'+ item.id+'/edit'}><Button>编辑</Button></Link>
                            <Link to={'/announcement?itemId='+item.id}><Button>公告</Button></Link>
                            <Link
                                to={'/trades/create/'+ item.id+'?title='+ item.itemShortTitle}><Button>报单</Button></Link>
                        </p>
                    </div>
                }
            </Spin>
        );
    }
}
