import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import HuikuanInfoForm from '../../components/HuikuanInfoForm/HuikuanInfoForm';
import ProductBaseInfoForm from '../../components/ProductBaseInfoForm/ProductBaseInfoForm';
import ShouyiYongjingForm from '../../components/ShouyiYongjingForm/ShouyiYongjingForm';
import ProductElementForm from '../../components/ProductElementForm/ProductElementForm';
import ProductDateTimeForm from '../../components/ProductDateTimeForm/ProductDateTimeForm';
import ProductDocumentsForm from '../../components/ProductDocumentsForm/ProductDocumentsForm';
import ProductContactForm from '../../components/ProductContactForm/ProductContactForm';


@connect(state=>({
    cates: state.product.cates,
    product: state.product.item,
    loading: state.product.loading,
    user: state.user,
}))
export default class EditItem extends Component {

    static propTypes = {
        form: PropTypes.object,
        dispatch: PropTypes.func,
        caste: PropTypes.array,
        product: PropTypes.object
    };

    constructor() {
        super(...arguments);
    }


    componentWillMount() {
        if (!this.props.cates.length) {
            this.fetchCates();
        }
        if (!(this.props.product && this.props.product.id)) {
            this.fetchItem(this.props.params.id);
        }
    };

    fetchCates() {
        this.props.dispatch({
            type: 'FETCH_PRODUCT_CATES'
        });
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_PRODUCT_ITEM',
            id
        });
    };


    render = ()=> {
        
        const {product} = this.props;

        return (
            <Spin spinning={this.props.loading}>
                <Tabs tabPosition="top">
                    <Tabs.TabPane tab="基本信息" key="tab-pane-1">
                        { product && <ProductBaseInfoForm {...this.props}/> }
                    </Tabs.TabPane>
                    <Tabs.TabPane tab="收益与佣金" key="tab-pane-2">
                        { product && <ShouyiYongjingForm {...this.props}/> }
                    </Tabs.TabPane>
                    <Tabs.TabPane tab="汇款账号" key="tab-pane-4">
                        { product && <HuikuanInfoForm {...this.props}/> }
                    </Tabs.TabPane>
                    <Tabs.TabPane tab="基本要素" key="tab-pane-5">
                        { product && <ProductElementForm {...this.props} /> }
                    </Tabs.TabPane>
                    <Tabs.TabPane tab="时间状态" key="tab-pane-6">
                        { product && <ProductDateTimeForm {...this.props} /> }
                    </Tabs.TabPane>
                    <Tabs.TabPane tab="相关附件" key="tab-pane-7">
                        { product && <ProductDocumentsForm {...this.props} /> }
                    </Tabs.TabPane>
                    <Tabs.TabPane tab="服务经理" key="tab-pane-8">
                        { product && <ProductContactForm {...this.props} /> }
                    </Tabs.TabPane>
                </Tabs>
            </Spin>
        );
    }
}
