import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin,

} from 'antd';
import HuikuanInfoForm from '../../components/HuikuanInfoForm/HuikuanInfoForm';
import ProductBaseInfoForm from '../../components/ProductBaseInfoForm/ProductBaseInfoForm';
import ShouyiYongjingForm from '../../components/ShouyiYongjingForm/ShouyiYongjingForm';
import ProductElementForm from '../../components/ProductElementForm/ProductElementForm';
import ProductDateTimeForm from '../../components/ProductDateTimeForm/ProductDateTimeForm';
import ProductDocumentsForm from '../../components/ProductDocumentsForm/ProductDocumentsForm';
import ProductContactForm from '../../components/ProductContactForm/ProductContactForm';


class PublishForm extends Component {
    constructor(props, content) {
        super(props, content);
    }

    handlePublish(e) {
        e.preventDefault();
        const data = {
            id: this.props.product.id,
            status: 1
        };
        this.props.dispatch({
            type: 'UPDATE_PRODUCT_ITEM',
            item: data
        });
    }


    render() {
        return (
            <div style={{textAlign:'center'}}>
                <h1>请确认产品各项信息已经填写完整!</h1>
                <Button type="primary" loading={this.props.loading} onClick={this.handlePublish.bind(this)} >
                    <Icon type="solution"/>发布
                </Button>
            </div>
        );
    }

}


@connect(state=>({
    user: state.user,
    cates: state.product.cates,
    product: state.product.item,
    loading: state.product.loading,
    isCreate: true,
}))
export default class AddItem extends Component {


    constructor(props, content) {
        super(props, content);
        this.state = {
            step: parseInt(location.hash.replace('#', ''), 10) || 1
        }
    }

    static propTypes = {
        dispatch: PropTypes.func,
        caste: PropTypes.array
    };


    componentWillMount() {
        const {product, cates} = this.props;
        if (!cates || !cates.length) {
            this.fetchCates();
        }
        if (!product || !product.id) {
            this.props.dispatch({
                type: 'CREATE_PRODUCT_ITEM'
            });
        }
    };

    fetchCates() {
        this.props.dispatch({
            type: 'FETCH_PRODUCT_CATES'
        });
    };


    render = ()=> {

        const {product} = this.props;

        const styles = require('./Product.less');

        const tabs = [{
            tab: '基本信息',
            children: ProductBaseInfoForm
        }, {
            tab: '收益佣金',
            children: ShouyiYongjingForm
        }, {
            tab: '汇款账号',
            children: HuikuanInfoForm
        }, {
            tab: '基本要素',
            children: ProductElementForm
        }, {
            tab: '时间',
            children: ProductDateTimeForm
        }, {
            tab: '相关附件',
            children: ProductDocumentsForm
        }, {
            tab: '服务经理',
            children: ProductContactForm
        }, {
            tab: '发布',
            children: PublishForm
        }].map((tabPane, index)=> {
            tabPane.key = 'tabs-pane-' + (index + 1);
            tabPane.disabled = index != this.state.step - 1;
            return tabPane;
        });

        

        return (
            <div className={styles.normal}>
                <Tabs ref="tabs" className={styles.tabs} tabPosition="left" >
                    { tabs.map(tp=>
                        <Tabs.TabPane tab={tp.tab} key={tp.key} >
                            {product && <tp.children {...this.props}  /> }
                        </Tabs.TabPane>
                    )}
                </Tabs>
            </div>
        );
    }
}


// <div style={{textAlign:'center', borderTop:'1px solid #eee', height:60, paddingTop:20 }}>
//     {
//         this.state.step > 1 &&
//         <Button loading={this.props.loading}
//                 style={{margin:'0 1em'}}
//                 onClick={handleStep.bind(this, -1)}><Icon type="save"/>上一步</Button>
//     }
//
//     {
//         this.state.step < tabs.length &&
//         <Button type="primary" loading={this.props.loading}
//                 style={{margin:'0 1em'}}
//                 onClick={handleStep.bind(this, 1)}><Icon type="save"/>下一步</Button>
//     }
//
//     {
//         this.state.step == tabs.length &&
//         <Button type="primary" loading={this.props.loading}
//         ><Icon type="solution"/>发布</Button>
//     }
// </div>
