import React, { Component, PropTypes } from 'react';
import { Router, Route, IndexRoute, Link } from 'react-router';




import { Collapse } from 'antd';
const Panel = Collapse.Panel;




export default class App extends Component {
    static propTypes = {
        children: PropTypes.object.isRequired,
    };

    static contextTypes = {
        store: PropTypes.object.isRequired
    };

    render(){
        const styles = require('./App.less');
        return (
            <div className={styles.normal}>
                <div className={styles.head}>
                    <h1>枢纽科技</h1>
                </div>
                <div className={styles.content}>
                    <div className={styles.side}>
                        <Collapse accordion>
                            <Panel header="产品管理">
                                <Link to="/products">产品列表</Link><br/>
                                <Link to="/products/create">增加产品</Link>
                            </Panel>
                            <Panel header="订单管理">
                                <Link to="/trades">订单列表</Link><br/>
                            </Panel>
                        </Collapse>
                    </div>
                    <div className={styles.main}>
                        {this.props.children}
                    </div>
                </div>
                <div className={styles.foot}>
                    Built with react, react-router, redux, redux-saga, ant-tool, css-modules, antd...
                </div>
            </div>
        );
    }
}





















