import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Table, Icon, Button} from 'antd';
import {serialize, formatDateTime, productStatusToString} from '../../utils';
import {Link} from 'react-router';


const columns = [
    {
        title: 'ID',
        dataIndex: 'id',
        key: 'id',
        width: 60
    }, {
        title: '标题',
        dataIndex: 'title',
        key: 'title',
    }, {
        title: '创建时间',
        dataIndex: 'dateCreated',
        key: 'dateCreated',
        width: 150,
        className: 'tac',
        render: (dateCreated, record)=>(
            <span>
                {dateCreated && formatDateTime(dateCreated)}
            </span>
        )
    }, {
        title: '状态',
        dataIndex: 'status',
        key: 'status',
        width: 120,
        className: 'tac',
        render: (status, record)=>(<span data-status={status}>{status?'有效':'无效'}</span>)
    }, {
        title: '操作',
        key: 'operation',
        width: 120,
        className: 'tac',
        render: (text, record)=>(
            <span>
                <a href={'/product/item?id='+ record.id}></a>
            </span>
        )
    }
];

@connect(state=>({
    items: state.announcement.items,
    loading: state.announcement.loading,
    total: state.announcement.total,
}))
export default class List extends Component {

    constructor(props, context) {
        super(props, context);

    }

    componentWillMount() {
        this.fetchList(this.props.location.query);
    };

    fetchList(query) {
        this.props.dispatch({
            type: 'FETCH_ANNOUNCEMENT_LIST',
            query
        });
    };

    handleRowClick({id}) {
        this.props.history.push('/announcement/' + id + '/edit');
    }



    render() {

        const {total, items, loading, history:{replace}, location:{pathname, query}} = this.props;



        const pagination = {
            total: total,
            pageSize: parseInt(query.s, 10) || 10,
            current: parseInt(query.p, 10) || 1,
            showSizeChanger: true,
            onShowSizeChange: (current, pageSize)=> {
                console.log('Current: ', current, '; PageSize: ', pageSize);
                query.p = current;
                query.s = pageSize;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            },
            onChange: (current)=> {
                console.log('Current: ', current);
                query.p = current;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            }
        };

        return <div>
            <h1>公告列表</h1>
            <Link to={'/announcement/create?itemId='+ query.itemId}><Button><Icon type="plus"/>添加</Button></Link>
            <Table className="ant-table" columns={columns}
                   dataSource={Array.isArray(items)?items:[]}
                   loading={loading}
                   pagination={pagination}
                   scroll={{ y: window.innerHeight-290 }}
                   onRowClick={this.handleRowClick.bind(this)}
            />
        </div>;
    }
}



