import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
} from 'antd';

@connect(state=>({
    loading: state.announcement.loading,
    announcement: state.announcement.item,
}))
@Form.create()
export default class EditItem extends Component {
    constructor() {
        super(...arguments);
    }


    componentWillMount() {
        if (!(this.props.announcement && this.props.announcement.id)) {
            this.fetchItem(this.props.params.id);
        }
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_ANNOUNCEMENT_ITEM',
            id
        });
    };

    handleSubmit(e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        console.log(data);
    }

    render() {
        const {announcement, loading, form:{getFieldProps}} = this.props;
        const formItemLayout = {
            labelCol: {span: 4},
            wrapperCol: {span: 14},
        };

        return (
            <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                <Form.Item label="标题" {...formItemLayout}>
                    <Input placeholder="公告标题" {...getFieldProps('title', {initialValue: announcement.title})}  />
                </Form.Item>
                <Form.Item label="内容" {...formItemLayout}>
                    <Input placeholder="公告内容" type="textarea" {...getFieldProps('announcement', {initialValue: announcement.announcement})}  />
                </Form.Item>
                <Form.Item wrapperCol={{offset: 4, span:10}} style={{marginTop:30}}>
                    <Button type="primary" htmlType="submit" loading={loading}><Icon type="save"/>保存</Button>
                </Form.Item>
            </Form>
        );
    }
}
