import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
} from 'antd';

@connect(state=>({
    loading: state.announcement.loading,
}))
@Form.create()
export default class AddItem extends Component{
    constructor(props, content) {
        super(props, content);
    }

    handleSubmit(e){
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        data.itemId = this.props.location.query.itemId;
        console.log(data);
        this.props.dispatch({
            type:'CREATE_ANNOUNCEMENT_ITEM',
            data
        });
    }

    render = ()=> {
        const {loading, form:{getFieldProps}} = this.props;
        const formItemLayout = {
            labelCol: {span: 4},
            wrapperCol: {span: 14},
        };
        return(
            <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                <Form.Item label="标题" {...formItemLayout}>
                    <Input placeholder="公告标题" {...getFieldProps('title')}  />
                </Form.Item>
                <Form.Item label="内容" {...formItemLayout}>
                    <Input placeholder="公告内容" type="textarea" {...getFieldProps('announcement')}  />
                </Form.Item>
                <Form.Item wrapperCol={{offset: 4, span:10}} style={{marginTop:30}}>
                    <Button type="primary" htmlType="submit" loading={loading}><Icon type="save"/>创建</Button>
                </Form.Item>
            </Form>
        );
    }
}
