import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table
} from 'antd';


import {arrayRemoveIndex, UUID} from '../../utils';

export function CreateBaseElement() {
    return {key: UUID()};
}

export function BaseElementTransform(objs) {
    return Object.keys(objs).map(key=>({
        key: UUID(),
        title: key,
        content: objs[key]
    }));
}

@Form.create()
export default class HuikuanInfoForm extends Component {
    constructor(props, context) {
        super(props, context);
        this.state = {
            elements: BaseElementTransform(props.product.elements)
        };

    }

    static propsType = {
        product: PropTypes.object,

    };

    /**
     * 删除基本要素
     * @param index
     * @param e
     */
    handleRemoveElement(index, e) {
        e.preventDefault();
        const elements = arrayRemoveIndex(this.state.elements, index);
        this.setState({elements: elements});
    }

    /**
     * 添加基本要素
     * @param e
     */
    handleAddElement(e) {
        e.preventDefault();
        let elements = [].concat(this.state.elements);
        elements.push(CreateBaseElement());

        this.setState({elements: elements});
    }

    handleSubmit(e) {
        e.preventDefault();
        const formData = this.props.form.getFieldsValue();
        const tmp = {};
        Object.keys(formData).map(index=> {
            if (formData[index].title != 'undefined') {
                tmp[formData[index].title] = formData[index].content;
            }
        });
        const data = {
            id: this.props.product.id,
            elements: JSON.stringify(tmp)
        }

        console.log('收到表单值：', data);

        this.props.dispatch({
            type: 'UPDATE_PRODUCT_ITEM',
            item: data
        });


    }

    render() {
        const {form:{getFieldProps}}  = this.props;
        return (
            <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                <Form.Item>
                    <h3>可以设置以下要素,或者自定义其他要素</h3>
                    <p>总规模、投资亮点、托管方、结算方式、资金用途、融资方、担保主体、风控措施、还款来源、发行方、认购起点、大小额配比</p>
                </Form.Item>
                <Form.Item>
                    {
                        this.state.elements.map((item, index)=>
                            <div key={item.key} style={{marginBottom:8}}>
                                <Input.Group>
                                    <Col span="6">
                                        <Input
                                            placeholder="标题" {...getFieldProps(index + '.title', {initialValue: item.title})} />
                                    </Col>
                                    <Col span="10">
                                        <Input type="textarea" placeholder="内容" autosize
                                            {...getFieldProps(index + '.content', {initialValue: item.content})}/>
                                    </Col>
                                    <Col span="4">
                                        <Icon type="cross" onClick={this.handleRemoveElement.bind(this, index)}/>
                                    </Col>
                                </Input.Group>
                            </div>
                        )
                    }
                </Form.Item>
                <Form.Item wrapperCol={{offset: 4, span:10}} style={{marginTop:30}}>
                    <Button onClick={this.handleAddElement.bind(this)} style={{marginRight:'1em'}}><Icon
                        type="plus"/>添加</Button>
                    <Button type="primary" htmlType="submit"><Icon type="save"/>保存</Button>
                </Form.Item>
            </Form>
        );
    }
}
