import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table
} from 'antd';

import {UUID} from '../../utils';

@Form.create()
export default class ProductDocumentsForm extends Component {
    constructor(props, context) {
        super(props, context);
        this.state = {
            fileList: props.product.documents.map(file=> {
                file.uid = UUID();
                file.url = file.file;
                file.status = 'done';
                return file;
            })
        };

    }

    static propsType = {
        product: PropTypes.object,

    };

    handleUpload(info) {
        let fileList = info.fileList;

        // 3. 按照服务器返回信息筛选成功上传的文件
        fileList = fileList.filter((file) => {
            if (file.response) {
                return file.response.status === 1;
            }
            return true;
        });

        // 2. 读取远程路径并显示链接
        fileList = fileList.map((file) => {
            if (file.response) {
                // 组件会将 file.url 作为链接进行展示
                //file.url = file.response.url;
                const {result, status, message} = file.response;
                if (status === 1 && result && result.length >= 1 && result[0].url) {
                    file.url = result[0].url;
                }
            }
            return file;
        });

        this.setState({fileList});
    }

    handleSubmit(e){
        e.preventDefault();
        const files = [];
        this.state.fileList.forEach(file=>{
            files.push({
                name: file.name,
                file: file.url
            });
        });
        const data = {
            id: this.props.product.id,
            documents: JSON.stringify(files)
        };

        console.log(data);

        this.props.dispatch({
            type: 'UPDATE_PRODUCT_ITEM',
            item: data
        });
    }
    render() {
        const {user, product} = this.props;
        return (
            <Form horizontal onSubmit={this.handleSubmit.bind(this)} style={{maxWidth:'800px', margin:'auto'}}>
                <Form.Item>
                    <Upload.Dragger action="/api/fileUpload/upload"
                                    multiple={true}
                                    headers={{
                                        authorization: user && user.token,
                                    }}
                                    onChange={this.handleUpload.bind(this)}
                                    fileList={this.state.fileList}>
                        <p className="ant-upload-drag-icon">
                            <Icon type="inbox"/>
                        </p>
                        <p className="ant-upload-text">点击或将文件拖拽到此区域上传</p>
                        <p className="ant-upload-hint">支持单个或批量上传，严禁上传公司内部资料及其他违禁文件</p>
                    </Upload.Dragger>
                </Form.Item>
                <Form.Item style={{marginTop:30, textAlign:'center'}}>
                    <Button type="primary" htmlType="submit"><Icon type="save"/>保存</Button>
                </Form.Item>
            </Form>
        );
    }
}
