import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table
} from 'antd';


import {arrayRemoveIndex, UUID} from '../../utils';

export function CreateBaseElement() {
    return {key: UUID()};
}

export function BaseElementTransform(arr) {
    return Object.keys(objs).map(key=>({
        key: UUID(),
        name: key,
        mobile: objs[key]
    }));
}

@Form.create()
export default class ProductContactForm extends Component {
    constructor(props, context) {
        super(props, context);
        this.state = {
            staffs: props.product.staffs.map(staffs=> {
                staffs.key = UUID();
                return staffs;
            })
        };

    }

    static propsType = {
        product: PropTypes.object,
    };

    /**
     * 删除基本要素
     * @param index
     * @param e
     */
    handleRemove(index, e) {
        e.preventDefault();
        const staffs = arrayRemoveIndex(this.state.staffs, index);
        this.setState({staffs: staffs});
    }

    /**
     * 添加基本要素
     * @param e
     */
    handleAdd(e) {
        e.preventDefault();
        let staffs = [].concat(this.state.staffs);
        staffs.push({key: UUID()});

        this.setState({staffs});
    }

    handleSubmit(e) {
        e.preventDefault();
        const formData = this.props.form.getFieldsValue();
        const tmp = Object.keys(formData).map(index=> {
            return {
                ...formData[index]
            }
        }).filter(item=>item.name && item.mobile);
        const data = {
            id: this.props.product.id,
            staffs: JSON.stringify(tmp)
        }

        console.log('收到表单值：', data);

        this.props.dispatch({
            type: 'UPDATE_PRODUCT_ITEM',
            item: data
        });


    }

    render() {
        const {form:{getFieldProps}}  = this.props;
        return (
            <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                <Form.Item>
                    {
                        this.state.staffs.map((item, index)=>
                            <div key={item.key} style={{marginBottom:8}}>
                                <Input.Group>
                                    <Col span="6">
                                        <Input placeholder="姓名"
                                            {...getFieldProps(index + '.name', {
                                                initialValue: item.name
                                            })} />
                                    </Col>
                                    <Col span="10">
                                        <Input placeholder="电话"
                                            {...getFieldProps(index + '.mobile', {
                                                initialValue: item.mobile
                                            })}/>
                                    </Col>
                                    <Col span="4">
                                        <Icon type="cross" onClick={this.handleRemove.bind(this, index)}/>
                                    </Col>
                                </Input.Group>
                            </div>
                        )
                    }
                </Form.Item>
                <Form.Item wrapperCol={{offset: 4, span:10}} style={{marginTop:30}}>
                    <Button onClick={this.handleAdd.bind(this)} style={{marginRight:'1em'}}><Icon
                        type="plus"/>添加</Button>
                    <Button type="primary" htmlType="submit"><Icon type="save"/>保存</Button>
                </Form.Item>
            </Form>
        );
    }
}
