import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
} from 'antd';

import {PRODUCT_STATUS, arrayRemoveIndex, UUID} from '../../utils';

const ProductStatus = Object.keys(PRODUCT_STATUS);


@Form.create()
export default class ProductBaseInfoForm extends Component {

    static propsType = {
        cates: PropTypes.array,
        product: PropTypes.object,
        user: PropTypes.object,
        dispatch: PropTypes.func
    };

    constructor(props, context) {
        super(props, context);

        this.state = {
            priviewVisible: false,
            priviewImage: '',
            fileList: []
        };

        const {itemPic} = props.product;

        if (itemPic) {
            this.state.fileList.push({
                uid: UUID(),
                status: 'done',
                url: itemPic,
                thumbUrl: itemPic + '!t'
            });
        } else {
            console.log('没有找到商品主图', props.product);
        }
    }


    handleCancel() {
        this.setState({
            priviewVisible: false,
        });
    };

    onChange(value) {
        console.log(value);
    };

    handleSubmit(e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();

        if (Array.isArray(data.categoryId) && data.categoryId.length === 2) {
            data.categoryId = data.categoryId[1];
        } else {
            delete data.categoryId;
        }

        if (this.state.fileList && this.state.fileList[0] && this.state.fileList[0].url) {
            data['itemPic'] = this.state.fileList[0].url;
        }

        data.id = this.props.product.id;

        console.log('收到表单值：', data);

        this.props.dispatch({
            type: 'UPDATE_PRODUCT_ITEM',
            item: data
        });

    };

    handleUpload(info) {

        let fileList = info.fileList;

        // 3. 按照服务器返回信息筛选成功上传的文件
        fileList = fileList.filter((file) => {
            if (file.response) {
                return file.response.status === 1;
            }
            return true;
        });

        // 1. 上传列表数量的限制
        //    只显示最近上传的一个，旧的会被新的顶掉
        fileList = fileList.slice(-1);


        // 2. 读取远程路径并显示链接
        fileList = fileList.map((file) => {
            if (file.response) {
                // 组件会将 file.url 作为链接进行展示
                //file.url = file.response.url;
                const {result, status, message} = file.response;
                if (status === 1 && result && result.length >= 1 && result[0].url) {
                    file.url = result[0].url;
                    file.thumbUrl = result[0].url + '!t';
                }
            }
            return file;
        });

        this.setState({fileList});
    };

    render() {

        const formItemLayout = {
            labelCol: {span: 4},
            wrapperCol: {span: 14},
        };

        const {user, cates, product, form:{getFieldProps}} = this.props;

        let productCate = [];

        if (product && product.categoryId && product.categoryParentId) {
            productCate = [product.categoryParentId, product.categoryId];
        }

        const styles = require('./ProductBaseInfoForm.less');

        return (
            <div>
                <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                    <Form.Item label="商品类目" {...formItemLayout} wrapperCol={{span: 6}}>
                        <Cascader
                            options={cates}
                            defaultValue={productCate}
                            {...getFieldProps('categoryId', {initialValue: productCate})}
                            placeholder="请选产品类目"/>
                    </Form.Item>
                    <Form.Item label="商品标题" {...formItemLayout}>
                        <Input placeholder="商品标题" {...getFieldProps('itemTitle', {initialValue: product.itemTitle})}  />
                    </Form.Item>
                    <Form.Item label="商品短标题" {...formItemLayout} wrapperCol={{span: 6}}>
                        <Input placeholder="商品短标题"
                            {...getFieldProps('itemShortTitle', {initialValue: product.itemShortTitle})} />
                    </Form.Item>
                    <Form.Item label="商品主图" {...formItemLayout}>
                        <Upload action="/api/fileUpload/upload" listType="picture-card"
                                multiple={true}
                                headers={{
                                authorization: user && user.token,
                            }}
                                onChange={this.handleUpload.bind(this)}
                                onPreview={(file) => {
                                this.setState({
                                    priviewImage: file.url,
                                    priviewVisible: true,
                                });
                            }}
                                fileList={this.state.fileList}>
                            <Icon type="upload"/>
                            <div className="ant-upload-text">上传照片</div>
                        </Upload>
                        <Modal visible={this.state.priviewVisible} footer={null}
                               width="100vw"
                               className={styles.imgPriviewDialog}
                               style={{height:'100vh', background:'transparent'}}
                               onCancel={this.handleCancel.bind(this)}>
                            <img src={this.state.priviewImage} style={{maxWidth:'100%'}}/>
                        </Modal>
                    </Form.Item>
                    <Form.Item label="商品简介" {...formItemLayout}>
                        <Input type="textarea" rows={5}
                               placeholder="商品简介"
                            {...getFieldProps('summary', {initialValue: product.summary})} />
                    </Form.Item>
                    <Form.Item label="募集目标" help="本期额度, 可以输入100万, 2亿等" {...formItemLayout} wrapperCol={{span:6}}>
                        <Input placeholder=""  {...getFieldProps('fundRaisedTarget', {
                            initialValue: product.fundRaisedTarget
                        })} />
                    </Form.Item>
                    <Form.Item label="产品期限" help="例如:半年期" {...formItemLayout} wrapperCol={{span:6}}>
                        <Input placeholder="" {...getFieldProps('duration', {
                            initialValue: product.duration
                        })} />
                    </Form.Item>
                    <Form.Item label="起投金额" help="最小购买份额"  {...formItemLayout} wrapperCol={{span:6}}>
                        <Input placeholder="" {...getFieldProps('minimumAmount', {
                            initialValue: product.minimumAmount
                        })} />
                    </Form.Item>
                    <Form.Item label="已预约" help="此处的已预约只用于显示" {...formItemLayout} wrapperCol={{span:6}}>
                        {
                            ((typeof product.fundReservationOver !== 'undefined') && ( product.fundReservationOver !== '')) ?
                                <div style={{maxWidth:500}}>
                                    <Input addonAfter={"实际:"+ product.fundReservationOver}
                                        {...getFieldProps('fundReservationOverFake', {
                                            initialValue: product.fundReservationOverFake
                                        })} />
                                </div>
                                :
                                <Input {...getFieldProps('fundReservationOverFake', {
                                    initialValue: product.fundReservationOverFake
                                })} />
                        }

                    </Form.Item>
                    <Form.Item label="已募集" help="此处的已募集只用于显示" {...formItemLayout} wrapperCol={{span:6}}>
                        {
                            ((typeof product.fundRaisedOver !== 'undefined') && (product.fundRaisedOver !== '')) ?
                                <div style={{maxWidth:500}}>
                                    <Input addonAfter={"实际:"+ product.fundRaisedOver}
                                        {...getFieldProps('fundRaisedOverFake', {
                                            initialValue: product.fundRaisedOverFake
                                        })} />
                                </div>
                                :
                                <Input {...getFieldProps('fundRaisedOverFake', {
                                    initialValue: product.fundRaisedOverFake
                                })} />
                        }
                    </Form.Item>
                    <Form.Item label="产品所属公司" {...formItemLayout} wrapperCol={{span: 6}}>
                        <Input placeholder="产品所属公司"
                            {...getFieldProps('company', {initialValue: product.company})} />
                    </Form.Item>
                    <Form.Item label="所属公司网址" {...formItemLayout} wrapperCol={{span: 6}}>
                        <Input placeholder="所属公司网址"
                            {...getFieldProps('website', {initialValue: product.website})} />
                    </Form.Item>
                    <Form.Item wrapperCol={{offset: 4, span:10}} style={{marginTop:30}}>
                        <Button type="primary" htmlType="submit"><Icon type="save"/>保存</Button>
                    </Form.Item>
                </Form>
                
            </div>
        );
    }
}




