import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table
} from 'antd';

@Form.create()
export default class HuikuanInfoForm extends Component {
    constructor(props, context) {
        super(props, context);
    }

    static propsType = {
        product: PropTypes.object
    };

    handleSubmit(e){
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        const {product} = this.props;

        data.id = product.id;
        console.log('收到表单值：', data);

        this.props.dispatch({
            type:'UPDATE_PRODUCT_ITEM',
            item: data
        });
    }

    render() {
        const formItemLayout = {
            labelCol: {span: 4},
            wrapperCol: {span: 14},
        };
        const {form:{getFieldProps}, product:{fundRaisedAccount}} = this.props;
        return (
            <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                <Form.Item label="名称" {...formItemLayout} wrapperCol={{span:6}}>
                    <Input placeholder="" {...getFieldProps('fundRaisedAccount.name', {initialValue: fundRaisedAccount.name})} />
                </Form.Item>
                <Form.Item label="银行帐号" {...formItemLayout} wrapperCol={{span:6}}>
                    <Input placeholder="" {...getFieldProps('fundRaisedAccount.number',{initialValue:fundRaisedAccount.number})} />
                </Form.Item>
                <Form.Item label="开户行" {...formItemLayout}>
                    <Input placeholder="" {...getFieldProps('fundRaisedAccount.bank',{initialValue:fundRaisedAccount.bank})} />
                </Form.Item>
                <Form.Item label="打款须知" {...formItemLayout}>
                    <Input type="textarea" rows={10} placeholder="" {...getFieldProps('fundRaisedAccount.memo',{initialValue:fundRaisedAccount.memo})} />
                </Form.Item>
                <Form.Item wrapperCol={{offset: 4, span:10}} style={{marginTop:30}}>
                    <Button type="primary" htmlType="submit"><Icon type="save"/>保存</Button>
                </Form.Item>
            </Form>
        );
    }
}
