import {takeLatest} from 'redux-saga';
import {take, call, put, fork, cancel, select} from 'redux-saga/effects';
import {fetchList, fetchCates, fetchItem, updateItem, createItem} from '../services/product';
import {message} from 'antd';

function* getList(query) {
    try {
        const {total, items} = yield call(fetchList, query);
        yield put({
            type: 'FETCH_PRODUCT_LIST_SUCCESS',
            total,
            items
        });
    } catch (err) {
        console.log(err);
        message.error(err);
        yield put({
            type: 'FETCH_PRODUCT_LIST_FAILED',
            err,
        });
    }
}

function* watchProductList() {
    while (true) {
        const {query} = yield take('FETCH_PRODUCT_LIST');
        yield fork(getList, query);
    }
}

function* getCates() {
    try {
        const cates = yield call(fetchCates);
        yield put({
            type: 'FETCH_PRODUCT_CATES_SUCCESS',
            cates
        });
    } catch (err) {
        console.log(err);
        message.error(err);
        yield put({
            type: 'FETCH_PRODUCT_CATES_FAILED',
            err,
        });
    }
}

function* watchProductCates() {
    yield takeLatest('FETCH_PRODUCT_CATES', getCates);
}


function* getItem(id) {
    try {
        const item = yield call(fetchItem, id);
        yield put({
            type: 'FETCH_PRODUCT_ITEM_SUCCESS',
            item
        });
    } catch (err) {
        console.log(err);
        message.error(err);
        yield put({
            type: 'FETCH_PRODUCT_ITEM_FAILED',
            err
        });
    }
}

function* watchProductItem() {
    while (true) {
        const {id} = yield take('FETCH_PRODUCT_ITEM');
        yield fork(getItem, id);
    }
}

function* editItem(item) {
    try{
        yield call(updateItem, item);
        message.success('保存成功!');
        yield put({
            type: 'UPDATE_PRODUCT_ITEM_SUCCESS',
        });
    }catch(err){
        console.log(err);
        message.error(err);
        yield put({
            type:'UPDATE_PRODUCT_ITEM_FAILED',
            err
        });
    }
}

function* watchEditProductItem(){
    while(true){
        const {item} = yield take('UPDATE_PRODUCT_ITEM');
        yield fork(editItem, item);
    }
}

function* addItem() {
    try{
        const item = yield call(createItem);
        yield put({
            type: 'CREATE_PRODUCT_ITEM_SUCCESS',
            item
        });
    }catch(err){
        console.log(err);
        message.error(err);
        yield put({
            type:'CREATE_PRODUCT_ITEM_FAILED',
            err
        });
    }
}

function* watchAddItem() {
    yield takeLatest('CREATE_PRODUCT_ITEM', addItem);
}


export default function*() {
    yield fork(watchProductList);
    yield fork(watchProductCates);
    yield fork(watchProductItem);
    yield fork(watchEditProductItem);
    yield fork(watchAddItem);
}
