import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';

import {
    formatDateTime,
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    remittanceAuditStatusToString
} from '../../utils';

@connect(state=>({
    loading: state.withdraw.loading,
    audit: state.withdraw.audit,
}))
@Form.create()
export default class PassItem extends Component {
    constructor() {
        super(...arguments);
    }


    componentDidMount() {
        this.fetchItem(this.props.params.id);
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_WITHDRAW_ITEM',
            id
        });
    };

    handleSubmit(status, e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        data.id = this.props.params.id;
        data.status = status;
        console.log(data);
        if (status == 9) {
            delete data.memo;
        }
        this.props.dispatch({
            type: 'PASS_WITHDRAW_ITEM',
            data
        });
    }

    render() {
        const {audit, loading, form:{getFieldProps}, location:{query}} = this.props;

        let title = (audit && audit.nickname ? audit.nickname + ' - ' : '');

        let readOnly = true;

        if (audit) {
            switch (audit.status) {
                case 1:
                    title += '报单审核详情';
                    readOnly = false;
                    break;
                case 5:
                    title += '审核失败';
                    break;
                case 9:
                    title += '审核成功';
            }
        } else {
            title += '提现审核详情';
        }

        const header = (<MainHeader breadcrumb={['审核管理', '提现审核','审核详情']} title={title}/>);

        let memo = [];

        if (audit) {
            if (audit.status == 1) {
                const {bankCard, balance, balanceLong, amountLong} = audit;
                if (!balance) {
                    memo.push('无余额可用');
                } else if (balanceLong < amountLong) {
                    memo.push('余额不足');
                }

                const {name, bank, bankBranch, num} = bankCard;

                if (!name) {
                    memo.push('无持卡人');
                }
                if (!num) {
                    memo.push('无银行卡号');
                }
                if (!bank || !bankBranch) {
                    memo.push('无开户行信息');
                }
            } else {
                memo.push(audit.memo);
            }
        }

        memo = memo.join('\n');


        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    {
                        audit &&
                        <Form horizontal>
                            <Form.Item label="申请时间" {...smallFormItemLayout}>
                                <Input placeholder="申请时间" readOnly
                                       defaultValue={audit.dateCreated && formatDateTime(audit.dateCreated) || '错误的时间'}
                                />
                            </Form.Item>
                            <Form.Item label="当前余额" {...smallFormItemLayout}>
                                <Input placeholder="当前余额" readOnly
                                       defaultValue={audit.balance}/>
                            </Form.Item>
                            <Form.Item label="持卡人信息" {...smallFormItemLayout}>
                                <Input placeholder="持卡人信息" readOnly
                                       defaultValue={'持卡人:'+(audit.name || '') + '   卡号:'+(audit.number || '')}/>
                            </Form.Item>
                            <Form.Item label="银行卡信息" {...smallFormItemLayout}>
                                <Input placeholder="银行卡信息" readOnly
                                       defaultValue={(audit.bankCard.bank || '') + ( audit.bankCard.bankBranch || '') }/>
                            </Form.Item>
                            <Form.Item label="提现金额"  {...smallFormItemLayout}>
                                <Input placeholder="实际入账金额" readOnly defaultValue={audit.amount}/>
                            </Form.Item>

                            <Form.Item label="拒绝理由" {...smallFormItemLayout}>
                                <Input placeholder="拒绝理由" readOnly={readOnly} type="textarea" autosize
                                    {...getFieldProps('memo', {
                                        initialValue: memo
                                    })}  />
                            </Form.Item>
                            <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                                {
                                    audit.status == 1 &&
                                    <span>
                                        <Button size="large" type="primary" onClick={this.handleSubmit.bind(this, 9)}>
                                            <Icon type="check-circle-o"/>通过
                                        </Button>
                                        <Button size="large" type="ghost" onClick={this.handleSubmit.bind(this, 5)}
                                                style={{margin:'auto 1em' }}>
                                            <Icon type="cross-circle-o"/>拒绝
                                        </Button>
                                    </span>
                                }
                                <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}>
                                    <Icon type="rollback"/>返回
                                </Button>
                            </Form.Item>
                        </Form>
                    }
                </Spin>
            </Layout>
        );
    }
}
