import React, {Component, PropTypes} from 'react';

import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import {
    arrayRemoveIndex,
    UUID,
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    handleUpload
} from '../../utils';

@Form.create()
export default class DocumentsForm extends Component {
    constructor(props, context) {
        super(props, context);
        this.state = {
            fileList: props.product.documents.map(file=> {
                file.uid = UUID();
                file.url = file.file;
                file.status = 'done';
                return file;
            })
        };

    }

    static propsType = {
        product: PropTypes.object,

    };

    componentWillMount(){
        
    }

    handleSubmit(e) {
        e.preventDefault();
        const files = [];
        this.state.fileList.forEach(file=> {
            files.push({
                name: file.name,
                file: file.url
            });
        });
        const data = {
            id: this.props.product.id,
            documents: JSON.stringify(files)
        };

        console.log(data);

        this.props.dispatch({
            type: 'UPDATE_PRODUCT_ITEM',
            item: data
        });
    }

    render() {
        const {user, loading} = this.props;
        return (
            <Spin spinning={loading}>
                <Form horizontal onSubmit={this.handleSubmit.bind(this)} style={{maxWidth:'800px', margin:'auto'}}>
                    <Form.Item>
                        <Upload.Dragger action="/api/fileUpload/upload"
                                        multiple={true}
                                        headers={{
                                            authorization: user && user.token,
                                        }}
                                        onChange={info=>this.setState({fileList: handleUpload(info)})}
                                        fileList={this.state.fileList}>
                            <p className="ant-upload-drag-icon">
                                <Icon type="inbox"/>
                            </p>
                            <p className="ant-upload-text">点击或将文件拖拽到此区域上传</p>
                            <p className="ant-upload-hint">支持单个或批量上传，严禁上传公司内部资料及其他违禁文件</p>
                        </Upload.Dragger>
                    </Form.Item>
                    <Form.Item style={{marginTop:30, textAlign:'center'}}>
                        <Button type="primary" htmlType="submit" loading={loading}><Icon type="save"/>保存</Button>
                        {
                            !this.props.isCreate &&
                            <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                    style={{marginLeft:'1em'}}>
                                <Icon type="rollback" />返回
                            </Button>
                        }
                    </Form.Item>
                </Form>
            </Spin>
        );
    }
}
