import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';

import {formItemLayout, footerFormSubmitLayout} from '../../utils';

@connect(state=>({
    loading: state.user.loading,
}))
@Form.create()
export default class AddItem extends Component {
    constructor(props, content) {
        super(props, content);
    }

    handleSubmit(e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        console.log(data);
        this.props.dispatch({
            type: 'CREATE_USER_ITEM',
            data
        });
    }

    render = ()=> {
        const {loading, form:{getFieldProps}, location:{query}} = this.props;

        const operation = (
            <div style={{textAlign:'right'}}>
                <Button.Group>
                    <Button type="ghost" onClick={e=>{e.preventDefault(); this.props.history.goBack();}}>
                        <Icon type="rollback"/>
                    </Button>
                </Button.Group>
            </div>
        );

        const header = (
            <MainHeader breadcrumb={['用户管理', '添加用户']}
                        title="添加用户"
                        operation={operation}
            />
        );
        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    <Form className="main-form" horizontal onSubmit={this.handleSubmit.bind(this)}>
                        <Form.Item label="用户名" help="请使用手机号" {...formItemLayout}>
                            <Input placeholder="用户名" {...getFieldProps('username')}  />
                        </Form.Item>
                        <Form.Item label="密码" {...formItemLayout}>
                            <Input placeholder="密码" type="password"
                                {...getFieldProps('password')}  />
                        </Form.Item>
                        <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                            <Button type="primary" htmlType="submit" loading={loading}><Icon type="save"/>创建</Button>
                            <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                    style={{marginLeft:'1em'}}>
                                <Icon type="rollback"/>返回
                            </Button>
                        </Form.Item>
                    </Form>
                </Spin>
            </Layout>
        );
    }
}
