import xFetch from './xFetch';
import {serialize} from '../utils';

export async function fetch(username, password) {
    return xFetch('/api/authenticate', {
        method: 'POST',
        body: serialize({username, password})
    });
}

export async function create(data) {
    return xFetch('/api/users', {
        method: 'POST',
        body: serialize(data)
    });
}

export async function fetchList(query) {
    return xFetch('/api/admin/users' + '?' + serialize(query));
}

export async function fetchItem(id) {
    return xFetch('/api/admin/users/' + id);
}

export async function updateItem(data) {
    return xFetch('/api/admin/users/' + data.id, {
        method: 'PUT',
        body: serialize(data)
    })
}

export async function clear() {
    sessionStorage.clear();
    return Promise.resolve();
}

export async function save(user) {
    sessionStorage.setItem('user', user);
    return Promise.resolve(user);
}


