import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin,
    Breadcrumb
} from 'antd';

import HuikuanInfoForm from '../../components/ProductForm/HuikuanInfoForm';
import BaseInfoForm from '../../components/ProductForm/BaseInfoForm';
import ShouyiYongjingForm from '../../components/ProductForm/ShouyiYongjingForm';
import ElementForm from '../../components/ProductForm/ElementForm';
import DateTimeStatusForm from '../../components/ProductForm/DateTimeStatusForm';
import DocumentsForm from '../../components/ProductForm/DocumentsForm';
import ContactForm from '../../components/ProductForm/ContactForm';
import MainHeader from '../../components/MainHeader/MainHeader';
import Layout from '../../components/Layout/Layout';

@connect(state=>({
    cates: state.product.cates,
    product: state.product.item,
    loading: state.product.loading,
    user: state.user,
}))
export default class EditItem extends Component {

    static propTypes = {
        form: PropTypes.object,
        dispatch: PropTypes.func,
        caste: PropTypes.array,
        product: PropTypes.object
    };

    constructor() {
        super(...arguments);
    }


    componentWillMount() {
        if (!this.props.cates.length) {
            this.fetchCates();
        }
        this.fetchItem(this.props.params.id);
    };

    fetchCates() {
        this.props.dispatch({
            type: 'FETCH_PRODUCT_CATES'
        });
    };

    fetchItem(id) {
        this.props.dispatch({
            type: 'FETCH_PRODUCT_ITEM',
            id
        });
    };


    render = ()=> {

        const {product} = this.props;

        const styles = require('./Product.less');

        const tabs = [{
            tab: '基本信息',
            children: BaseInfoForm
        }, {
            tab: '收益佣金',
            children: ShouyiYongjingForm
        }, {
            tab: '汇款账号',
            children: HuikuanInfoForm
        }, {
            tab: '基本要素',
            children: ElementForm
        }, {
            tab: '时间状态',
            children: DateTimeStatusForm
        }, {
            tab: '相关附件',
            children: DocumentsForm
        }, {
            tab: '服务经理',
            children: ContactForm
        }].map((tabPane, index)=> {
            tabPane.key = 'tabs-pane-' + (index + 1);
            return tabPane;
        });


        const header = (<MainHeader breadcrumb={['产品管理', '产品详情']}
                                    title={(product && product.itemShortTitle ?  product.itemShortTitle + ' - ' : '') + '产品详情'}/>);


        return (
            <Layout header={header}>
                <Tabs className={styles.tabs} tabPosition="left">
                    { tabs.map(tp=>
                        <Tabs.TabPane tab={tp.tab} key={tp.key}>
                            {product && <tp.children {...this.props}  /> }
                        </Tabs.TabPane>
                    )}
                </Tabs>
            </Layout>
        );
    }
}
