import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {Table, Icon, Button, Switch, Form} from 'antd';
import {serialize, formatDateTime, productStatusToString, footerFormSubmitLayout} from '../../utils';
import {Link} from 'react-router';
import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';


@connect(state=>({
    items: state.announcement.items,
    loading: state.announcement.loading,
    total: state.announcement.total,
}))
export default class List extends Component {

    constructor(props, context) {
        super(props, context);
        this.state = {
            filterVisible: false
        }
    }

    componentDidMount() {
        this.fetchList(this.props.location.query);
    };

    fetchList(query) {
        this.props.dispatch({
            type: 'FETCH_ANNOUNCEMENT_LIST',
            query
        });
    };

    handleRowClick({id}) {
        this.props.history.push('/announcement/' + id + '/edit');
    }

    handleFilterVisible() {

    }

    render() {

        const {total, items, loading, history:{replace}, location:{pathname, query}} = this.props;

        const pagination = {
            total: total,
            pageSize: parseInt(query.s, 10) || 10,
            current: parseInt(query.p, 10) || 1,
            showSizeChanger: true,
            onShowSizeChange: (current, pageSize)=> {
                console.log('Current: ', current, '; PageSize: ', pageSize);
                query.p = current;
                query.s = pageSize;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            },
            onChange: (current)=> {
                console.log('Current: ', current);
                query.p = current;
                replace(pathname + '?' + serialize(query));
                this.fetchList(query);
            }
        };

        const columns = [
            {
                title: 'ID',
                dataIndex: 'id',
                key: 'id',
                width: 60
            }, {
                title: '标题',
                dataIndex: 'title',
                key: 'title',
                width: 200,
            }, {
                title: '内容',
                dataIndex: 'announcement',
                key: 'announcement',
                width: 200,
                render: (announcement, record)=>(
                    <span title={announcement}>
                        {announcement && (announcement.length > 20 ? announcement.substr(0, 20) + '...' : announcement)}
                    </span>
                )
            }, {
                title: '创建时间',
                dataIndex: 'dateCreated',
                key: 'dateCreated',
                width: 150,
                className: 'tac',
                render: (dateCreated, record)=>(
                    <span>
                        {dateCreated && formatDateTime(dateCreated)}
                    </span>
                )
            }, {
                title: '状态',
                dataIndex: 'status',
                key: 'status',
                width: 120,
                className: 'tac',
                render: (text, record)=>(
                    <span onClick={e=>{e.stopPropagation(); e.preventDefault();}}>
                        <Switch checkedChildren="开" unCheckedChildren="关" defaultChecked={record.status}
                                onChange={checked=>{
                                    this.props.dispatch({
                                        type:'UPDATE_ANNOUNCEMENT_ITEM',
                                        data:{
                                            id: record.id,
                                            status: checked ? 1: 0
                                        }
                                    })
                                }}
                        />
                    </span>
                )
            }
        ];

        const operation = (
            <div style={{textAlign:'right'}}>
                <Button.Group>
                    <Button type="ghost">
                        <Link to={'/announcement/create?itemId='+ query.itemId + '&title='+ query.title}>
                            <Icon type="plus"/>
                        </Link>
                    </Button>
                    <Button type="ghost" onClick={this.handleFilterVisible.bind(this)}>
                        <Icon type="filter"/>
                    </Button>
                    <Button type="ghost" onClick={e=>{e.preventDefault(); this.props.history.goBack();}}>
                        <Icon type="rollback"/>
                    </Button>
                </Button.Group>
            </div>
        );

        const header = (
            <MainHeader breadcrumb={['产品管理', '产品详情', '公告列表']}
                        title={(query.title ? query.title + ' - ' : '') + '公告列表'}
                        operation={operation}
            />
        );

        const footer = (
            <div style={{margin:'10px 0'}}>
                <Link to={'/announcement/create?itemId='+ query.itemId + '&title='+ query.title}>
                    <Button  type="primary">
                        <Icon type="plus"/>添加
                    </Button>
                </Link>
                <Button style={{margin:'0 1em'}}  type="ghost" onClick={e=>{e.preventDefault(); this.props.history.goBack();}}>
                    <Icon type="rollback"/>返回
                </Button>
            </div>
        );

        return (
            <Layout header={header} >
                <Table className="list-table" columns={columns}
                       dataSource={Array.isArray(items)?items:[]}
                       loading={loading}
                       pagination={pagination}
                       scroll={{ y: window.innerHeight-(this.state.filterVisible? 203 :150) }}
                       onRowClick={this.handleRowClick.bind(this)}
                />
            </Layout>
        );
    }
}


// <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
//     <Link to={'/announcement/create?itemId='+ query.itemId + '&title='+ query.title}>
//         <Button size="large"><Icon type="plus"/>添加</Button>
//     </Link>
//     <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
//             style={{marginLeft:'1em'}}>
//         <Icon type="rollback"/>返回
//     </Button>
// </Form.Item>


