import {fork} from 'redux-saga/effects';

// Use require.context to require sagas automatically
// Ref: https://webpack.github.io/docs/context.html
const context = require.context('./', false, /\.js$/);
const keys = context.keys().filter(item => item !== './index.js' && item !== './SagaManager.js' && item !== './RESTful.js');

export default function* root() {
    for (let i = 0; i < keys.length; i++) {
        let fn = context(keys[i]);
        if (typeof fn === 'function') {
            yield  fork(fn);
        } else if (typeof fn['default'] === 'function') {
            yield  fork(fn['default']);
        }
        // yield fork(context(keys[i]));
    }
}
