import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    message,
    Icon,
    Modal,
    Spin
} from 'antd';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';
import HeaderOperation from '../../components/HeaderOperation/HeaderOperation';
import FooterOperation from '../../components/FooterOperation/FooterOperation';

import {
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    NULL,
} from '../../utils';

@connect(state=>({
    loading: state.user.loading,
    user: state.user,
}))
@Form.create()
export default class EditItem extends Component {
    constructor() {
        super(...arguments);
    }

    componentDidMount() {

    };

    componentWillReceiveProps(nextProps) {

    }

    handleSubmit(e) {
        e.preventDefault();
        const data = this.props.form.getFieldsValue();
        data.username = this.props.user.username;
        if (data.password && data.newPassword && data.confirmPassword) {
            if (data.confirmPassword !== data.newPassword) {
                message.error('新密码与重复密码不相同!');
                return;
            }
            this.props.dispatch({
                type: 'MODIFY_USER_PASSWORD',
                data
            });
        } else {
            message.error('密码不能为空!');
        }

    }

    render() {
        const {user, loading, form:{getFieldProps}, history} = this.props;

        const header = (
            <MainHeader breadcrumb={['用户管理', '用户详情']}
                        title={'修改密码'}
                        operation={<HeaderOperation history={history}/>}
            />
        );

        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    {
                        user &&
                        <Form className="main-form" horizontal onSubmit={this.handleSubmit.bind(this)}>
                            <Form.Item label="用户名" {...smallFormItemLayout}>
                                { user.username }
                            </Form.Item>
                            <Form.Item label="原密码" {...smallFormItemLayout}>
                                <Input type="password" {...getFieldProps('password')} />
                            </Form.Item>
                            <Form.Item label="新密码" {...smallFormItemLayout}>
                                <Input type="password" {...getFieldProps('newPassword')} />
                            </Form.Item>
                            <Form.Item label="重复密码" {...smallFormItemLayout}>
                                <Input type="password" {...getFieldProps('confirmPassword')} />
                            </Form.Item>
                            <FooterOperation {...this.props} isEdit={true} hasCancel={false} afterButtons={
                                <Button onClick={(e)=> {
                                    e.preventDefault();
                                    this.props.history.goBack()
                                }} style={{marginLeft: '1em'}}>
                                    <Icon type="rollback"/>返回
                                </Button>
                            }/>
                        </Form>
                    }
                </Spin>
            </Layout>
        );
    }
}
