import {handleActions} from 'redux-actions';
import {combineReducer} from 'redux';

const remittance = handleActions({
    ['FETCH_REMITTANCE_LIST'](state) {
        return {...state, loading: true,};
    },
    ['FETCH_REMITTANCE_LIST_SUCCESS'](state, action) {
        return {...state, loading: false, audits: action.items, total: action.total};
    },
    ['FETCH_REMITTANCE_LIST_FAILED'](state, action) {
        return {...state, err: action.err, loading: false};
    },
    ['FETCH_REMITTANCE_ITEM'](state) {
        return {...state, loading: true,};
    },
    ['FETCH_REMITTANCE_ITEM_SUCCESS'](state, action) {
        return {...state, loading: false, audit: action.item};
    },
    ['FETCH_REMITTANCE_ITEM_FAILED'](state, action) {
        return {...state, err: action.err, loading: false};
    },
    ['PASS_REMITTANCE_ITEM'](state){
        return {...state, loading: true};
    },
    ['PASS_REMITTANCE_ITEM_SUCCESS'](state, action){
        const audit = {...state.audit, status: action.status};
        return {...state, loading: false, audit};
    },
    ['PASS_REMITTANCE_ITEM_FAILED'](state, action){
        return {...state, loading: false, err: action.err};
    }
}, {
    drawMoneys:[],
    audits: [],
    loading: false,
});


export default remittance;
