import React, {Component, PropTypes} from 'react';
import {connect} from 'react-redux';
import {
    Row,
    Col,
    Form,
    Input,
    Button,
    Checkbox,
    Select,
    message,
    Tabs,
    Cascader,
    Radio,
    Upload,
    Icon,
    Modal,
    DatePicker,
    Table,
    Spin
} from 'antd';

import {
    formatDateTime,
    formItemLayout,
    smallFormItemLayout,
    footerFormSubmitLayout,
    handleUpload
} from '../../utils';

import Layout from '../../components/Layout/Layout';
import MainHeader from '../../components/MainHeader/MainHeader';

@connect(state=>({
    item: state.trade.item,
    loading: state.trade.loading
}))
@Form.create()
export default class Commission extends Component {

    componentDidMount() {
        const {dispatch, params:{id}} = this.props;
        dispatch({
            type: 'FETCH_TRADE_ITEM',
            id
        });
    };


    handleSubmit(e) {
        e.preventDefault();
        alert('ok');
        this.props.dispatch({
            type: 'SETTLEMENT_TRADE_ITEM',
            id: this.props.item.id
        })
    }

    render() {

        const {item, loading, form:{getFieldProps}, location:{query}} = this.props;

        const header = (<MainHeader breadcrumb={['订单管理', '订单详情', '佣金发放']}
                                    title={(item && item.shortTitle + ' - ' || '') + '佣金发放'}/>);

        return (
            <Layout header={header}>
                <Spin spinning={loading}>
                    <Form horizontal onSubmit={this.handleSubmit.bind(this)}>
                        <Form.Item label="产品" {...smallFormItemLayout}>
                            <p>{item && item.title}</p>
                        </Form.Item>

                        <Form.Item label="确认打款金额" {...smallFormItemLayout}>
                            <Input placeholder="确认打款金额"
                                   readOnly
                                {...getFieldProps('remittanceAmount', {
                                    initialValue: item && item.remittanceAmount
                                })}  />
                        </Form.Item>
                        <Form.Item label="实际佣金" {...smallFormItemLayout}>
                            <Input placeholder="实际佣金"
                                   readOnly
                                {...getFieldProps('realReturn', {
                                    initialValue: item && item.commission
                                })}  />
                        </Form.Item>
                        <Form.Item {...footerFormSubmitLayout} style={{marginTop:30}}>
                            <Button type="primary" htmlType="submit" loading={loading}><Icon type="save"/>发放</Button>
                            <Button onClick={e=>{e.preventDefault(); this.props.history.goBack();}}
                                    style={{marginLeft:'1em'}}>
                                <Icon type="rollback"/>返回
                            </Button>
                        </Form.Item>
                    </Form>
                </Spin>
            </Layout>
        );
    }
}


// <div className={styles.trade}>
//     <div className={styles.tradeTable}>
//         <Row type="flex" justify="space-around" align="middle">
//             <Col span={tw}>产品</Col>
//             <Col span={vw}>{item.title}</Col>
//         </Row>
//         <Row type="flex" justify="space-around" align="middle">
//             <Col span={tw}>确认打款金额</Col>
//             <Col span={vw}>{item.remittanceAmount}</Col>
//         </Row>
//
//         <Row type="flex" justify="space-around" align="middle">
//             <Col span={tw}>实际佣金</Col>
//             <Col span={vw}>{item.realReturn && item.realReturn.yj}</Col>
//         </Row>
//     </div>
//     <p>
//         <Button onClick={this.handleGoBack.bind(this)}>返回</Button>
//         {
//             (item.status == 11 || item.status == 21) &&
//             <Button onClick={this.handleCommission.bind(this)}>发放</Button>
//         }
//     </p>
// </div>
