import {takeLatest} from 'redux-saga';
import {take, call, put, fork, cancel} from 'redux-saga/effects';
import {fetch, clear, save, create, fetchList} from '../services/user';
import {message} from 'antd';

function* authorize(username, password, push) {
    try {
        const user = yield call(fetch, username, password);
        console.log(user);
        yield put({type: 'LOGIN_SUCCESS', user});
        console.log('login ok');
        push('/');
    } catch (err) {
        yield put({type: 'LOGIN_ERROR', err})
    }
}

function* loginFlow() {
    while (true) {
        console.log('login flow');
        const {username, password, push} = yield take('LOGIN_REQUEST');
        yield fork(authorize, username, password, push);
        yield take(['LOGOUT', 'LOGIN_ERROR']);
        yield call(clear);
    }
}

function* addItem(data) {
    try{
        yield call(create, data);
        yield put({type: 'CREATE_USER_ITEM_SUCCESS'});
    }catch(err){
        console.log(err);
        message.error(err);
        yield put({type: 'CREATE_USER_ITEM_FAILED', err});
    }
}

function* watchAddItem(){
    while(true){
        const {data} = yield take('CREATE_USER_ITEM');
        yield fork(addItem, data);
    }
}

function* getList(query){
    try{
        const {items, total} = yield call(fetchList, query);
        yield put({
            type:'FETCH_USER_LIST_SUCCESS',
            items: items,
            total
        });
    }catch(err){
        console.log(err);
        message.error(err);
        yield put({type: 'FETCH_USER_LIST_FAILED', err});
    }
}

function* watchList() {
    while(true){
        const {query} = yield take('FETCH_USER_LIST');
        yield fork(getList, query);
    }
}

export default function* () {
    yield fork(loginFlow);
    yield fork(watchAddItem);
    yield fork(watchList);
}

