import React, {PropTypes, Component} from 'react';
import {Route, IndexRoute, Link} from 'react-router';
import {
    Home,
    NotFound,
    Login,
    App,
    ProductList,
    ProductAddItem,
    ProductEditItem,
    TradeList,
    TradeItem,
    Commission,
    Contract,
    TradeAddItem,
    AnnouncementList,
    AnnouncementEditItem,
    AnnouncementAddItem,
    RemittanceAuditList,
    RemittanceAuditPassItem,
    WithDrawList,
    PassWithDrawItem,
    CustomMessageList,
    CustomMessageAddItem,
    CustomMessageItem,
    BaseUpload,
    UsersAddItem,
    UsersList
} from '../containers/index';

export default (store)=> {
    const requireAuth = (nextState, replace, cb) => {
        const {user} = store.getState();
        if (!user || !user.token) {
            replace('/login');
        }
        cb();
    };
    return (
        <Route path="/">
            <Route onEnter={requireAuth} component={App}>
                <IndexRoute component={Home}/>
                <Route path="products">
                    <IndexRoute component={ProductList}/>
                    <Route path="create" component={ProductAddItem}/>
                    <Route path=":id" component={ProductEditItem}/>
                </Route>
                <Route path="trades">
                    <IndexRoute component={TradeList}/>
                    <Route path="create" component={TradeAddItem}/>
                    <Route path=":id" component={TradeItem}/>
                    <Route path="commission/:id" component={Commission}/>
                    <Route path="contract/:id" component={Contract}/>
                </Route>
                <Route path="announcement">
                    <IndexRoute component={AnnouncementList}/>
                    <Route path="create" component={AnnouncementAddItem}/>
                    <Route path=":id/edit" component={AnnouncementEditItem}/>
                </Route>
                <Route path="remittance">
                    <Route path="audits">
                        <IndexRoute component={RemittanceAuditList}/>
                        <Route path=":id" component={RemittanceAuditPassItem}/>
                    </Route>
                </Route>
                <Route path="withdraw">
                    <Route path="audits">
                        <IndexRoute component={WithDrawList}/>
                        <Route path=":id" component={PassWithDrawItem}/>
                    </Route>
                </Route>
                <Route path="customMessages">
                    <IndexRoute component={CustomMessageList}/>
                    <Route path="create" component={CustomMessageAddItem}/>
                    <Route path=":id" component={CustomMessageItem}/>
                </Route>
                <Route path="upload" component={BaseUpload}/>
                <Route path="admin">
                    <Route path="users">
                        <IndexRoute component={UsersList} />
                        <Route path="create" component={UsersAddItem} />
                    </Route>
                </Route>
            </Route>
            <Route path="/login" component={Login}/>
            <Route path="*" component={NotFound}/>
        </Route>
    );
};

//
